/*
 * Decompiled with CFR 0.152.
 */
package bdi4jade.plan.planbody;

import bdi4jade.event.GoalEvent;
import bdi4jade.goal.Goal;
import bdi4jade.goal.GoalStatus;
import bdi4jade.goal.ParallelGoal;
import bdi4jade.plan.Plan;
import bdi4jade.plan.planbody.AbstractPlanBody;
import bdi4jade.plan.planbody.OutputPlanBody;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ParallelGoalPlanBody
extends AbstractPlanBody
implements OutputPlanBody {
    private static final Log log = LogFactory.getLog(ParallelGoalPlanBody.class);
    private static final long serialVersionUID = -5919677537834351951L;
    protected List<Goal> completedGoals;
    protected boolean dispatched;
    protected GoalEvent failedGoal;
    protected ParallelGoal parallelGoal;

    public void action() {
        if (this.dispatched) {
            GoalEvent goalEvent = this.getGoalEvent();
            if (goalEvent == null) {
                return;
            }
            if (GoalStatus.ACHIEVED.equals((Object)goalEvent.getStatus())) {
                this.completedGoals.add(goalEvent.getGoal());
                log.debug((Object)("Goal " + goalEvent.getGoal() + " completed!"));
                if (this.completedGoals.size() == this.parallelGoal.getGoals().size()) {
                    this.setEndState(Plan.EndState.SUCCESSFUL);
                    log.debug((Object)"All goals completed.");
                }
            } else {
                this.failedGoal = goalEvent;
                this.setEndState(Plan.EndState.FAILED);
                log.debug((Object)("A goal has failed: " + goalEvent.getGoal()));
            }
        } else {
            for (Goal goal : this.parallelGoal.getGoals()) {
                this.dispatchSubgoalAndListen(goal);
            }
            this.dispatched = true;
            log.debug((Object)"Goals dispatched!");
        }
    }

    @Override
    public void onStart() {
        this.parallelGoal = (ParallelGoal)this.getGoal();
        this.completedGoals = new ArrayList<Goal>(this.parallelGoal.getGoals().size());
        this.failedGoal = null;
        this.dispatched = false;
    }

    @Override
    public void setGoalOutput(Goal goal) {
        if (!(this.getGoal() instanceof ParallelGoal)) {
            throw new IllegalArgumentException("ParallelGoal expected.");
        }
        ParallelGoal parGoal = (ParallelGoal)goal;
        parGoal.setCompletedGoals(this.completedGoals);
        parGoal.setFailedGoal(this.failedGoal);
    }
}

