/*
 * Decompiled with CFR 0.152.
 */
package bdi4jade.plan.planbody;

import bdi4jade.event.GoalEvent;
import bdi4jade.exception.ParameterException;
import bdi4jade.goal.Goal;
import bdi4jade.goal.GoalStatus;
import bdi4jade.goal.SequentialGoal;
import bdi4jade.plan.Plan;
import bdi4jade.plan.planbody.AbstractPlanBody;
import bdi4jade.plan.planbody.OutputPlanBody;
import bdi4jade.util.ReflectionUtils;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SequentialGoalPlanBody
extends AbstractPlanBody
implements OutputPlanBody {
    private static final Log log = LogFactory.getLog(SequentialGoalPlanBody.class);
    private static final long serialVersionUID = -5919677537834351951L;
    protected List<Goal> completedGoals;
    protected Goal currentGoal;
    protected GoalEvent failedGoal;
    protected Iterator<Goal> it;

    public void action() {
        if (this.currentGoal == null) {
            if (!this.it.hasNext()) {
                this.setEndState(Plan.EndState.SUCCESSFUL);
                log.debug((Object)"All goals completed.");
            } else {
                this.currentGoal = this.it.next();
                if (!this.completedGoals.isEmpty()) {
                    try {
                        this.setNextGoal(this.completedGoals.get(this.completedGoals.size() - 1), this.currentGoal);
                    }
                    catch (ParameterException gpe) {
                        log.error((Object)gpe);
                        gpe.printStackTrace();
                        this.setEndState(Plan.EndState.FAILED);
                        return;
                    }
                }
                this.dispatchSubgoalAndListen(this.currentGoal);
                log.debug((Object)("Dispatching goal: " + this.currentGoal));
            }
        } else {
            GoalEvent goalEvent = this.getGoalEvent();
            if (goalEvent == null) {
                return;
            }
            if (GoalStatus.ACHIEVED.equals((Object)goalEvent.getStatus())) {
                this.completedGoals.add(goalEvent.getGoal());
                this.currentGoal = null;
                log.debug((Object)("Goal " + goalEvent.getGoal() + " completed!"));
            } else {
                this.failedGoal = goalEvent;
                this.setEndState(Plan.EndState.FAILED);
                log.debug((Object)("A goal has failed: " + goalEvent.getGoal()));
            }
        }
    }

    @Override
    public void onStart() {
        if (!(this.getGoal() instanceof SequentialGoal)) {
            throw new IllegalArgumentException("SequentialGoal expected.");
        }
        SequentialGoal goal = (SequentialGoal)this.getGoal();
        this.it = goal.getGoals().iterator();
        this.currentGoal = null;
        this.failedGoal = null;
        this.completedGoals = new ArrayList<Goal>(goal.getGoals().size());
    }

    @Override
    public void setGoalOutput(Goal goal) {
        SequentialGoal seqGoal = (SequentialGoal)goal;
        seqGoal.setCompletedGoals(this.completedGoals);
        seqGoal.setFailedGoal(this.failedGoal);
    }

    protected void setNextGoal(Goal previousGoal, Goal goal) throws ParameterException {
        ReflectionUtils.setupParameters(previousGoal, goal);
    }
}

