/*
 * Decompiled with CFR 0.152.
 */
package bdi4jade.belief;

import bdi4jade.belief.Belief;
import bdi4jade.core.Capability;
import bdi4jade.event.BeliefEvent;
import bdi4jade.event.BeliefListener;
import bdi4jade.exception.BeliefAlreadyExistsException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class BeliefBase
implements Serializable {
    private static final long serialVersionUID = -6411530721625492882L;
    private final Set<BeliefListener> beliefListeners;
    private final Map<Object, Belief<?, ?>> beliefs;
    private final Map<Class<?>, Set<Belief<?, ?>>> beliefsByType;
    private Capability capability;

    protected BeliefBase() {
        this.beliefListeners = new HashSet<BeliefListener>();
        this.beliefs = new HashMap();
        this.beliefsByType = new HashMap();
    }

    public BeliefBase(Capability capability) {
        this(capability, null);
    }

    public BeliefBase(Capability capability, Set<Belief<?, ?>> beliefs) {
        if (capability == null) {
            throw new NullPointerException("Capability must be not null.");
        }
        this.capability = capability;
        this.beliefListeners = new HashSet<BeliefListener>();
        this.beliefs = new HashMap();
        this.beliefsByType = new HashMap();
        if (beliefs != null) {
            for (Belief<?, ?> belief : beliefs) {
                this.putBelief(belief);
            }
        }
    }

    public void addBelief(Belief<?, ?> belief) {
        if (this.hasBelief(belief.getName())) {
            throw new BeliefAlreadyExistsException(belief);
        }
        belief.addBeliefBase(this);
        this.putBelief(belief);
        this.notifyBeliefChanged(new BeliefEvent(belief, BeliefEvent.Action.BELIEF_ADDED));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addBeliefListener(BeliefListener beliefListener) {
        Set<BeliefListener> set = this.beliefListeners;
        synchronized (set) {
            this.beliefListeners.add(beliefListener);
        }
    }

    public void addOrUpdateBelief(Belief<?, ?> belief) {
        if (this.hasBelief(belief.getName())) {
            this.updateBelief(belief.getName(), belief.getValue());
        } else {
            this.addBelief(belief);
        }
    }

    public Belief<?, ?> getBelief(Object name) {
        Belief<?, ?> belief = this.beliefs.get(name);
        if (belief == null && this.capability.getWholeCapability() != null) {
            belief = this.capability.getWholeCapability().getBeliefBase().getBelief(name);
        }
        return belief;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<BeliefListener> getBeliefListeners() {
        Set<BeliefListener> set = this.beliefListeners;
        synchronized (set) {
            return new HashSet<BeliefListener>(this.beliefListeners);
        }
    }

    public Collection<Belief<?, ?>> getBeliefs() {
        LinkedList beliefs = new LinkedList();
        this.getBeliefs(beliefs);
        return beliefs;
    }

    private void getBeliefs(Collection<Belief<?, ?>> beliefs) {
        beliefs.addAll(this.beliefs.values());
        if (this.capability.getWholeCapability() != null) {
            this.capability.getWholeCapability().getBeliefBase().getBeliefs(beliefs);
        }
    }

    public Set<Belief<?, ?>> getBeliefsAssignableFrom(Class<?> beliefNameType) {
        HashSet beliefs = new HashSet();
        this.getBeliefsAssignableFrom(beliefNameType, beliefs);
        return beliefs;
    }

    private void getBeliefsAssignableFrom(Class<?> beliefNameType, Collection<Belief<?, ?>> beliefs) {
        for (Class<?> beliefSupertype : this.beliefsByType.keySet()) {
            if (!beliefSupertype.isAssignableFrom(beliefNameType)) continue;
            Set<Belief<?, ?>> beliefsOfType = this.beliefsByType.get(beliefSupertype);
            beliefs.addAll(beliefsOfType);
        }
        if (this.capability.getWholeCapability() != null) {
            this.capability.getWholeCapability().getBeliefBase().getBeliefsAssignableFrom(beliefNameType, beliefs);
        }
    }

    public Set<Belief<?, ?>> getBeliefsByType(Class<?> beliefNameType) {
        HashSet beliefs = new HashSet();
        this.getBeliefsByType(beliefNameType, beliefs);
        return beliefs;
    }

    private void getBeliefsByType(Class<?> beliefNameType, Collection<Belief<?, ?>> beliefs) {
        Set<Belief<?, ?>> beliefsOfType = this.beliefsByType.get(beliefNameType);
        if (beliefsOfType != null) {
            beliefs.addAll(beliefsOfType);
        }
        if (this.capability.getWholeCapability() != null) {
            this.capability.getWholeCapability().getBeliefBase().getBeliefsByType(beliefNameType, beliefs);
        }
    }

    public Capability getCapability() {
        return this.capability;
    }

    public Set<Belief<?, ?>> getLocalBeliefs() {
        return new HashSet(this.beliefs.values());
    }

    public Set<Belief<?, ?>> getLocalBeliefsAssignableFrom(Class<?> beliefNameType) {
        HashSet beliefs = new HashSet();
        for (Class<?> beliefsubtype : this.beliefsByType.keySet()) {
            if (!beliefNameType.isAssignableFrom(beliefsubtype)) continue;
            Set<Belief<?, ?>> beliefsOfType = this.beliefsByType.get(beliefsubtype);
            beliefs.addAll(beliefsOfType);
        }
        return beliefs;
    }

    public Set<Belief<?, ?>> getLocalBeliefsByType(Class<?> beliefNameType) {
        HashSet beliefs = new HashSet();
        Set<Belief<?, ?>> beliefsOfType = this.beliefsByType.get(beliefNameType);
        if (beliefsOfType != null) {
            beliefs.addAll(beliefsOfType);
        }
        return beliefs;
    }

    public List<Object> getLocalBeliefValues() {
        ArrayList<Object> beliefValues = new ArrayList<Object>(this.beliefs.size());
        for (Belief<?, ?> belief : this.beliefs.values()) {
            beliefValues.add(belief.getValue());
        }
        return beliefValues;
    }

    public boolean hasBelief(Object name) {
        boolean hasBelief = this.beliefs.containsKey(name);
        if (!hasBelief && this.capability.getWholeCapability() != null) {
            hasBelief = this.capability.getWholeCapability().getBeliefBase().hasBelief(name);
        }
        return hasBelief;
    }

    public boolean hasBelief(Object name, Object value) {
        Belief<?, ?> belief = this.getBelief(name);
        if (belief == null) {
            return false;
        }
        if (belief.getValue() == null) {
            return value == null;
        }
        return belief.getValue() == value;
    }

    protected void notifyBeliefChanged(BeliefEvent beliefChanged) {
        Set<BeliefListener> beliefListeners = this.getBeliefListeners();
        for (BeliefListener beliefListener : beliefListeners) {
            beliefListener.eventOccurred(beliefChanged);
        }
        for (Capability part : this.capability.getPartCapabilities()) {
            part.getBeliefBase().notifyBeliefChanged(beliefChanged);
        }
    }

    private void putBelief(Belief<?, ?> belief) {
        Class<?> beliefNameType = belief.getName().getClass();
        Set<Belief<?, ?>> beliefTypeSet = this.beliefsByType.get(beliefNameType);
        if (beliefTypeSet == null) {
            beliefTypeSet = new HashSet();
            this.beliefsByType.put(beliefNameType, beliefTypeSet);
        }
        beliefTypeSet.add(belief);
        this.beliefs.put(belief.getName(), belief);
    }

    public Belief<?, ?> removeBelief(Object name) {
        Belief<?, ?> belief = this.beliefs.remove(name);
        if (belief != null) {
            Class<?> beliefNameType = belief.getName().getClass();
            Set<Belief<?, ?>> beliefTypeSet = this.beliefsByType.get(beliefNameType);
            boolean removed = beliefTypeSet.remove(belief);
            assert (removed);
            if (beliefTypeSet.isEmpty()) {
                this.beliefsByType.remove(beliefNameType);
            }
            belief.removeBeliefBase(this);
            this.notifyBeliefChanged(new BeliefEvent(belief, BeliefEvent.Action.BELIEF_REMOVED));
        } else if (this.capability.getWholeCapability() != null) {
            belief = this.capability.getWholeCapability().getBeliefBase().removeBelief(name);
        }
        return belief;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeBeliefListener(BeliefListener beliefListener) {
        Set<BeliefListener> set = this.beliefListeners;
        synchronized (set) {
            this.beliefListeners.remove(beliefListener);
        }
    }

    protected void setCapability(Capability capability) {
        this.capability = capability;
    }

    public int size() {
        return this.beliefs.size();
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("Belief base of Capability ");
        if (this.capability == null) {
            sb.append(" NO ID");
        } else {
            sb.append(this.capability.getId());
        }
        sb.append(" = ").append(this.beliefs.values());
        return sb.toString();
    }

    public boolean updateBelief(Object name, Object value) {
        Belief<?, ?> belief = this.beliefs.get(name);
        if (belief != null) {
            belief.setValue(value);
            return true;
        }
        if (this.capability.getWholeCapability() != null) {
            return this.capability.getWholeCapability().getBeliefBase().updateBelief(name, value);
        }
        return false;
    }
}

