/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package br.ufrgs.inf.prosoft.aplcache.adapter;

import br.ufrgs.inf.prosoft.aplcache.metadata.Method;
import br.ufrgs.inf.prosoft.aplcache.metadata.Occurrence;
import br.ufrgs.inf.prosoft.aplcache.metadata.OccurrenceConcrete;
import br.ufrgs.inf.prosoft.aplcache.metadata.OccurrenceReference;
import br.ufrgs.inf.prosoft.trace.Parameter;
import br.ufrgs.inf.prosoft.trace.Trace;
import br.ufrgs.inf.prosoft.trace.TraceReference;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;

/**
 * @author romulo
 */
public class TraceReader extends br.ufrgs.inf.prosoft.trace.reader.TraceReader {

  private static final Logger LOGGER = Logger.getLogger(TraceReader.class.getName());

  public static List<Method> groupByMethods(List<Trace> traces) {
    Map<String, Method> methodNameHasOccurrences = new HashMap<>();
    while (!traces.isEmpty()) {
      Trace trace = traces.remove(0);
      try {
        Occurrence occurrence;
        if (trace instanceof TraceReference) {
          TraceReference traceReference = (TraceReference) trace;
          occurrence = new OccurrenceReference(traceReference.getIndex(),
            trace.getStartTime(), trace.getEndTime(), trace.getUserSession());
        } else {
          occurrence = new OccurrenceConcrete(
            trace.getParameters().stream().map(Parameter::getData).toArray(),
            trace.getReturn().getData(),
            trace.getStartTime(),
            trace.getEndTime(),
            trace.getUserSession()
          );
        }
        try {
          methodNameHasOccurrences.get(trace.getName()).addOccurrence(occurrence);
        } catch (Exception ex) {
          Method method = new Method(trace.getName());
          method.addOccurrence(occurrence);
          methodNameHasOccurrences.put(trace.getName(), method);
        }
      } catch (Exception e) {
        LOGGER.log(Level.INFO, "Trace discarted: {0}", trace);
      }
    }
    return methodNameHasOccurrences.values().stream().collect(Collectors.toList());
  }
}
