/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package br.ufrgs.inf.prosoft.cache.tools;

import java.io.FileWriter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Stream;

/**
 *
 * @author romulo
 */
public class Distinct {

    private static final Logger LOGGER = Logger.getLogger(Reducer.class.getName());

    public static void reduce(String uncachedPath, String reducePath, String prefix) {
        reduce(uncachedPath, reducePath, prefix, true);
    }

    public static void reduce(String uncachedPath, String reducePath, String prefix, boolean hash) {
        MessageDigest messageDigest;
        try {
            messageDigest = MessageDigest.getInstance("sha-512");
        } catch (NoSuchAlgorithmException ex) {
            LOGGER.log(Level.SEVERE, "Cannot hash");
            return;
        }
        Map<String, Map<String, Integer>> methodHasParametersUsage = new HashMap<>();
        try (Stream<String> lines = Files.lines(Paths.get(uncachedPath))) {
            lines.forEach(line -> {
                int indexOf = line.indexOf(" : ");
                String method = line.substring(0, indexOf);
                String parameters = line.substring(indexOf + 3);
                methodHasParametersUsage.compute(method, (key, previous) -> {
                    if (previous == null) {
                        previous = new HashMap<>();
                    }
                    previous.merge(parameters, 1, Integer::sum);
                    return previous;
                });
            });

            try (FileWriter fileWriter = new FileWriter(reducePath, true)) {
                methodHasParametersUsage.entrySet().stream().forEach(entry -> {
                    entry.getValue().entrySet().forEach(innerEntry -> {
                        try {
                            String parameters = innerEntry.getKey();
                            if (hash) {
                                parameters = String.valueOf(messageDigest.digest(parameters.getBytes()));
                            }
                            fileWriter.write(prefix + entry.getKey() + "," + parameters + "," + innerEntry.getValue() + "\n");
                        } catch (IOException ex) {
                            LOGGER.log(Level.SEVERE, "IOException {0}", ex);
                        }
                    });
                });
            } catch (IOException ex) {
                Logger.getLogger(Distinct.class.getName()).log(Level.SEVERE, null, ex);
            }
        } catch (IOException ex) {
            LOGGER.log(Level.SEVERE, "file not found {0}", uncachedPath);
        }
    }
}
