package br.ufrgs.inf.prosoft.memoizeittf.adapter;

import java.math.BigDecimal;
import java.math.MathContext;
import java.util.ArrayList;
import java.util.List;

public class Thresholds {

  private static final List<BigDecimal> DISTANCES = new ArrayList<>();
  public static long population;
  private static BigDecimal averageDistance;
  private static BigDecimal stdDevDistance;

  public static void reset() {
    Thresholds.DISTANCES.clear();
    Thresholds.averageDistance = null;
    Thresholds.stdDevDistance = null;
  }

  public static void addDistance(BigDecimal distance) {
    DISTANCES.add(distance);
    Thresholds.averageDistance = null;
    Thresholds.stdDevDistance = null;
  }

  public static BigDecimal getAverageDistance() {
    if (DISTANCES.isEmpty()) return BigDecimal.ZERO;
    return DISTANCES.stream().reduce(BigDecimal::add).orElse(BigDecimal.ZERO).divide(BigDecimal.valueOf(DISTANCES.size()), MathContext.DECIMAL128);
  }

  public static BigDecimal getStdDevDistance() {
    if (population == 0) return BigDecimal.ZERO;
    if (stdDevDistance != null) return stdDevDistance;
    BigDecimal mean = getAverageDistance();
    BigDecimal temp = DISTANCES.stream()
      .map(difference -> difference.subtract(mean).multiply(difference.subtract(mean)))
      .reduce(BigDecimal::add)
      .orElse(BigDecimal.ZERO);
    stdDevDistance = temp.divide(BigDecimal.valueOf(population), MathContext.DECIMAL128).sqrt(MathContext.DECIMAL128);
    return stdDevDistance;
  }

  public static BigDecimal distanceThreshold(int kStdDev) {
    return getAverageDistance().subtract((getStdDevDistance().multiply(BigDecimal.valueOf(kStdDev))));
  }

  public static BigDecimal distanceThreshold() {
    return BigDecimal.valueOf(0.5);
  }

}
