/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package br.ufrgs.inf.prosoft.memoizeittf.utils;

import br.ufrgs.inf.prosoft.memoizeittf.facade.Method;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;

/**
 *
 * @author romulo
 */
public class Methods {

    private final List<br.ufrgs.inf.prosoft.memoizeit.Method> memoizeitMethods;
    private final List<br.ufrgs.inf.prosoft.tfcache.metadata.Method> tfcacheMethods;

    public Methods(List<Method> methods) {
        this.memoizeitMethods = getMemoizeitMethods(methods);
        this.tfcacheMethods = getTfcacheMethods(methods);
    }

    public void synchronize() {
        if (this.memoizeitMethods.size() == this.tfcacheMethods.size()) {
            return;
        }
        {
            List<String> remainingMethodReferences = this.memoizeitMethods.stream().map(method -> method.getName()).collect(Collectors.toList());
            this.tfcacheMethods.removeIf(method -> !remainingMethodReferences.contains(method.getName()));
        }
        {
            List<String> remainingMethodReferences = this.tfcacheMethods.stream().map(method -> method.getName()).collect(Collectors.toList());
            this.memoizeitMethods.removeIf(method -> !remainingMethodReferences.contains(method.getName()));
        }
    }

    public static List<br.ufrgs.inf.prosoft.memoizeit.Method> getMemoizeitMethods(List<Method> methods) {
        return methods.stream().map(Method::getMemoizeitMethod).collect(Collectors.toList());
    }

    public List<br.ufrgs.inf.prosoft.memoizeit.Method> getMemoizeitMethods() {
        return this.memoizeitMethods;
    }

    public static List<br.ufrgs.inf.prosoft.tfcache.metadata.Method> getTfcacheMethods(List<Method> methods) {
        return methods.stream().map(Method::getTfcacheMethod).collect(Collectors.toList());
    }

    public List<br.ufrgs.inf.prosoft.tfcache.metadata.Method> getTfcacheMethods() {
        return this.tfcacheMethods;
    }

    public void iterate(BiConsumer<br.ufrgs.inf.prosoft.memoizeit.Method, br.ufrgs.inf.prosoft.tfcache.metadata.Method> consumer) {
        if (this.memoizeitMethods.size() != this.tfcacheMethods.size()) {
            throw new RuntimeException("Unsync lists");
        }
        for (int i = 0; i < this.memoizeitMethods.size(); i++) {
            consumer.accept(this.memoizeitMethods.get(i), this.tfcacheMethods.get(i));
        }
    }

}
