/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package br.ufrgs.inf.prosoft.requestssimulator.requests;

import br.ufrgs.inf.prosoft.requestssimulator.Session;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;

/**
 *
 * @author romulo
 */
public class MultipartRequest extends Request {

    private final String forms;

    protected MultipartRequest(RequestPlan requestPlan, Session session, String URL, String forms) {
        super(requestPlan, session, URL);
        this.forms = forms;
    }

    protected MultipartRequest(RequestPlan requestPlan, Session session, String URL, String headers, String forms) {
        super(requestPlan, session, URL, headers);
        this.forms = forms;
    }

    protected MultipartRequest(RequestPlan requestPlan, Session session, String URL, String headers, String forms, Collection<String> storeFields) {
        super(requestPlan, session, URL, headers, storeFields);
        this.forms = forms;
    }

    protected String getForms() {
        return this.forms;
    }

    public Stream<Map.Entry<String, String>> forms() {
        Map<String, String> forms = new HashMap<>();
        if (this.forms != null) {
            String[] formsPairs = this.forms.split("&");
            for (String formPair : formsPairs) {
                String[] pair = formPair.split("=");
                if (pair.length > 1) {
                    forms.put(pair[0], pair[1]);
                }
            }
        }
        return forms.entrySet().stream();
    }

    @Override
    public void fireRequest() {
        try (CloseableHttpClient httpClient = HttpClientBuilder.create().build()) {
            String stringURL = fillPropertyVariable(getURL());
            HttpPost httpPost = new HttpPost(stringURL);
            MultipartEntityBuilder multipartEntityBuilder = MultipartEntityBuilder.create();
            forms().forEach(entry -> {
                if (entry.getKey().equals("file")) {
                    File file = new File(Request.HOME_PATH, entry.getValue());
                    multipartEntityBuilder.addBinaryBody(entry.getKey(), file);
                } else {
                    multipartEntityBuilder.addTextBody(entry.getKey(), fillPropertyVariable(entry.getValue()));
                }
            });
            HttpEntity httpEntity = multipartEntityBuilder.build();
            httpPost.setEntity(httpEntity);
            headers().forEach(entry -> {
                String value = fillPropertyVariable(entry.getValue());
                httpPost.setHeader(entry.getKey(), value);
            });
            try (CloseableHttpResponse closeableHttpResponse = httpClient.execute(httpPost)) {
                int responseCode = closeableHttpResponse.getStatusLine().getStatusCode();
                if (responseCode < 400) {
                    Logger.getGlobal().log(Level.INFO, "{0} on {1} {2}", new Object[]{responseCode, getMethod(), stringURL});
                    List<String> setCookies = Arrays.asList(closeableHttpResponse.getHeaders("Set-Cookie")).stream()
                            .map(header -> header.getName() + "=" + header.getValue())
                            .collect(Collectors.toList());
                    storeCookies(setCookies);
                    try (BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(closeableHttpResponse.getEntity().getContent()))) {
                        String response = bufferedReader.lines().collect(Collectors.joining());
                        processResponse(response);
                    }
                } else {
                    Logger.getGlobal().log(Level.SEVERE, "error {0} on {1} {2}", new Object[]{responseCode, getMethod(), stringURL});
                }
                log(responseCode);
            }
        } catch (IOException e) {
            Logger.getGlobal().log(Level.SEVERE, "IOException");
        } catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}
