/*
 * Decompiled with CFR 0.152.
 */
package ca.uqac.lif.bullwinkle.output;

import ca.uqac.lif.bullwinkle.ParseNode;
import ca.uqac.lif.bullwinkle.output.OutputFormatVisitor;
import java.util.ArrayDeque;
import java.util.Deque;

public class XmlVisitor
implements OutputFormatVisitor {
    private final Deque<String> m_parents = new ArrayDeque<String>();
    private final Deque<String> m_indents = new ArrayDeque<String>();
    private final StringBuilder m_output = new StringBuilder();
    private static final String s_indent = "  ";
    private String m_topElementName = "parsetree";
    private String m_tokenElementName = "token";

    public XmlVisitor() {
        this.m_indents.push("");
    }

    public void setTopElementName(String name) {
        this.m_topElementName = name;
    }

    public void setTokenElementName(String name) {
        this.m_tokenElementName = name;
    }

    @Override
    public void visit(ParseNode node) {
        String label = node.getValue();
        String current_indent = String.valueOf(this.m_indents.peek()) + s_indent;
        if (label == null) {
            label = node.getToken();
            this.m_output.append(current_indent).append("<").append(this.m_tokenElementName).append(">\n");
            this.m_indents.push(current_indent);
            current_indent = this.m_indents.peek();
            this.m_output.append(current_indent).append(label).append("\n");
            this.m_parents.push(this.m_tokenElementName);
        } else {
            label = label.replace("<", "");
            label = label.replace(">", "");
            this.m_output.append(current_indent).append("<").append(label).append(">\n");
            this.m_parents.push(label);
            this.m_indents.push(current_indent);
        }
    }

    @Override
    public void pop() {
        String element_name = this.m_parents.pop();
        String current_indent = this.m_indents.pop();
        this.m_output.append(current_indent).append("</").append(element_name).append(">\n");
    }

    @Override
    public String toOutputString() {
        StringBuilder out = new StringBuilder();
        out.append("<?xml version=\"1.0\" encoding=\"utf-8\" ?>\n");
        out.append("<!-- File auto-generated by Bullwinkle -->\n");
        out.append("<").append(this.m_topElementName).append(">\n").append((CharSequence)this.m_output).append("</").append(this.m_topElementName).append(">");
        return out.toString();
    }
}

