/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package br.ufrgs.inf.prosoft.requestssimulator;

/**
 *
 * @author romulo
 */
public class Main {

    public static void main(String[] args) {
        System.setProperty("java.util.logging.SimpleFormatter.format", "[%1$tF %1$tT+%1$tL] [%4$-7s] [RequestsSimulator] %5$s %n");

        String profilePath = null;
        String tracePath = null;
        String logPath = null;
        long time = 0;
        int users = 1;
        if (args.length < 2) {
            System.err.println("<ProfilePath> <time> [<users>] [<LogPath>]");
            System.err.println("<ProfilePath> <TracePath>");
            System.exit(1);
        }
        profilePath = args[0];
        try {
            time = Long.valueOf(args[1]);
        } catch (NumberFormatException ex) {
            if (args.length > 2) {
                System.err.println("<time> must be a number");
                System.exit(1);
            }
            tracePath = args[1];
        }
        if (args.length == 3) {
            try {
                users = Integer.valueOf(args[2]);
            } catch (NumberFormatException ex) {
                logPath = args[2];
                System.out.println("<users> not informed. Using default " + users);
            }
        } else if (args.length == 4) {
            try {
                users = Integer.valueOf(args[2]);
            } catch (NumberFormatException ex) {
                System.err.println("<users> must be a number");
                System.exit(1);
            }
            logPath = args[3];
        }
        Profile profile = ProfileReader.parseFile(profilePath);
        if (tracePath == null) {
            Simulator.simulate(profile, time, users, logPath);
        } else {
            LogExecutor.execute(profile, tracePath);
        }
    }
}
