/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package br.ufrgs.inf.prosoft.requestssimulator;

import com.google.gson.JsonParser;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import java.util.stream.Stream;

/**
 *
 * @author romulo
 */
public class Reducer {

    private static final Logger LOGGER = Logger.getLogger(Reducer.class.getName());

    public static void reduce(String throughputPath, String reducePath, String prefix) {
        try (Stream<String> lines = Files.lines(Paths.get(throughputPath))) {
            JsonParser jsonParser = new JsonParser();
            List<Long> seconds = lines.parallel()
                    .map(line -> jsonParser.parse(line).getAsJsonObject().get("time").getAsLong() / 1000)
                    .collect(Collectors.toList());

            Long min = seconds.stream().parallel().min(Long::compare).get();
            Long max = seconds.stream().parallel().max(Long::compare).get();

            Map<Long, Long> secondHasRequests = seconds.stream().parallel().map(time -> time - min)
                    .collect(Collectors.groupingBy(Function.identity(), Collectors.counting()));

            max -= min;

            try (FileWriter fileWriter = new FileWriter(reducePath, true)) {
                Long last = 0L;
                for (long i = 0; i <= max; i++) {
                    Long get = secondHasRequests.get(i);
                    if (get == null) {
                        get = 0L;
                    }
                    get += last;
                    fileWriter.write(prefix + i + "," + get + "\n");
                    last = get;
                }
            }
        } catch (IOException ex) {
            LOGGER.log(Level.SEVERE, "file not found {0}", throughputPath);
        }
    }
}
