/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package br.ufrgs.inf.prosoft.requestssimulator;

import br.ufrgs.inf.prosoft.requestssimulator.requests.RequestPlan;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 *
 * @author romulo
 */
public class Profile {

    private final Collection<RequestPlan> roots;
    private final Map<String, RequestPlan> urlHasRequestPlan;
    private List<List<JsonObject>> logs;

    public Profile(Map<String, RequestPlan> urlHasRequestPlan) {
        this.urlHasRequestPlan = urlHasRequestPlan;
        Map<String, RequestPlan> rootsReferences = new HashMap<>(this.urlHasRequestPlan);
        this.urlHasRequestPlan.forEach((reference, requestPlan) -> {
            if (reference.charAt(0) == '*') {
                rootsReferences.remove(reference);
                return;
            }
            if (requestPlan.links().count() == 0) {
                rootsReferences.remove(reference);
                return;
            }
            requestPlan.links().forEach(linkReference -> {
                rootsReferences.remove(linkReference.getReference());
            });
        });
        this.roots = rootsReferences.values();
    }

    public Session newSession() {
        return new Session(this.roots);
    }

    public RequestPlan getRequestPlan(String requestPlanReference) {
        return this.urlHasRequestPlan.get(requestPlanReference);
    }

    public List<List<JsonObject>> getLogs() {
        return logs;
    }

    public void run(long time) {
        this.logs = new ArrayList<>();
        long end = System.currentTimeMillis() + time;
        while (System.currentTimeMillis() < end) {
            Session session = new Session(this.roots);
            session.run();
            List<JsonObject> sessionLogs = session.getLogs();
            this.logs.add(sessionLogs);
        }
    }
}
