/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package br.ufrgs.inf.prosoft.requestssimulator;

import br.ufrgs.inf.prosoft.requestssimulator.requests.RequestPlan;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import java.util.logging.Level;
import java.util.logging.Logger;

/**
 *
 * @author romulo
 */
public class ProfileReader {

    public static Profile parseFile(String profilePath) {
        FileReader fileReader = null;
        try {
            fileReader = new FileReader(profilePath);
        } catch (FileNotFoundException ex) {
            Logger.getLogger(ProfileReader.class.getName()).log(Level.SEVERE, "File not found");
            System.exit(1);
        }
        Map<String, RequestPlan> urlHasRequestPlan = new HashMap<>();
        Gson gson = new Gson();
        JsonParser jsonParser = new JsonParser();
        JsonObject jsonObject = jsonParser.parse(fileReader).getAsJsonObject();
        jsonObject.entrySet().forEach(entry -> {
            RequestPlan requestPlan = gson.fromJson(entry.getValue(), RequestPlan.class);
            requestPlan.setReference(entry.getKey());
            urlHasRequestPlan.put(requestPlan.getReference(), requestPlan);
        });
        jsonObject.entrySet().forEach(entry -> {
            RequestPlan requestPlan = urlHasRequestPlan.get(entry.getKey());
            Collection<String> linksReferences = new ArrayList<>();
            JsonObject jsonRequestPlan = entry.getValue().getAsJsonObject();
            JsonElement linksReferencesElement = jsonRequestPlan.get("linksReferences");
            if (linksReferencesElement != null) {
                linksReferencesElement.getAsJsonArray().forEach(linkElement -> {
                    linksReferences.add(linkElement.getAsString());
                });
                linksReferences.forEach(new Consumer<String>() {
                    @Override
                    public void accept(String linkReference) {
                        RequestPlan link;
                        if (linkReference.charAt(0) == '*') {
                            link = urlHasRequestPlan.get(linkReference.substring(1));
                            if (link == null) {
                                throw new RuntimeException("link not declared: " + linkReference);
                            }
                            link.links().forEach(referenceToCopy -> {
                                accept(referenceToCopy.getReference());
                            });
                        } else {
                            link = urlHasRequestPlan.get(linkReference);
                            if (link == null) {
                                throw new RuntimeException("link not declared: " + linkReference);
                            }
                            requestPlan.addLink(link);
                        }
                    }
                });
            }
            JsonElement requirementsReferences = jsonRequestPlan.get("requirementsReferences");
            if (requirementsReferences != null) {
                requirementsReferences.getAsJsonArray().forEach(requirementReference -> {
                    RequestPlan link = urlHasRequestPlan.get(requirementReference.getAsString());
                    requestPlan.addRequirement(link);
                });
            }
        });
        Profile profile = new Profile(urlHasRequestPlan);
        return profile;
    }
}
