/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package br.ufrgs.inf.prosoft.requestssimulator.requests;

import br.ufrgs.inf.prosoft.requestssimulator.Session;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Random;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;

/**
 *
 * @author romulo
 */
public class RequestPlan {

    private final String method;
    private final String URL;
    private final String data;
    private List<RequestPlan> readLinks;
    private List<RequestPlan> writeLinks;
    private Collection<String> storeFields;
    private Collection<RequestPlan> requirements;
    private String headers;
    private String forms;

    private RequestPlan(String URL) {
        this.method = "GET";
        this.URL = URL;
        this.data = null;
    }

    private RequestPlan(String URL, String data) {
        this.method = "POST";
        this.URL = URL;
        this.data = data;
    }

    public static RequestPlan get(String URL) {
        return new RequestPlan(URL);
    }

    public static RequestPlan post(String URL, String data) {
        return new RequestPlan(URL, data);
    }

    public String getMethod() {
        return this.method;
    }

    public String getReference() {
        return this.method + "@" + this.URL;
    }

    public RequestPlan addHeader(String header) {
        if (this.headers == null || this.headers.isEmpty()) {
            this.headers = header;
        } else {
            this.headers += "; " + header;
        }
        return this;
    }

    public RequestPlan setHeaders(String headers) {
        this.headers = headers;
        return this;
    }

    public RequestPlan addForm(String form) {
        if (this.method.equals("GET")) {
            throw new RuntimeException("Adding form to GET request");
        }
        if (this.forms == null) {
            this.forms = form;
        } else {
            this.forms += "; " + form;
        }
        return this;
    }

    public RequestPlan setForms(String forms) {
        if (this.method.equals("GET")) {
            throw new RuntimeException("Adding form to GET request");
        }
        this.forms = forms;
        return this;
    }

    public Stream<RequestPlan> links() {
        if (this.readLinks == null && this.writeLinks == null) {
            return Stream.empty();
        }
        if (this.readLinks != null && this.writeLinks != null) {
            return Stream.concat(this.readLinks.stream(), this.writeLinks.stream());
        }
        if (this.readLinks != null) {
            return this.readLinks.stream();
        }
        return this.writeLinks.stream();
    }

    public RequestPlan addLink(RequestPlan requestPlan) {
        if (requestPlan.getMethod().equals("GET")) {
            if (this.readLinks == null) {
                this.readLinks = new ArrayList<>();
            }
            this.readLinks.add(requestPlan);
        } else {
            if (this.writeLinks == null) {
                this.writeLinks = new ArrayList<>();
            }
            this.writeLinks.add(requestPlan);
        }
        return this;
    }

    public RequestPlan addLinks(Collection<RequestPlan> requestPlans) {
        requestPlans.forEach(requestPlan -> addLink(requestPlan));
        return this;
    }

    public RequestPlan addRequirement(RequestPlan requestPlan) {
        if (this.requirements == null) {
            this.requirements = new ArrayList<>();
        }
        this.requirements.add(requestPlan);
        return this;
    }

    protected Stream<RequestPlan> requirements() {
        if (this.requirements == null || this.requirements.isEmpty()) {
            return Stream.empty();
        }
        return this.requirements.stream();
    }

    protected Stream<String> storeFields() {
        if (this.storeFields == null || this.storeFields.isEmpty()) {
            return Stream.empty();
        }
        return this.storeFields.stream();
    }

    public Request pickNextRequest(Session session) {
        Random random = new Random();
        int probability = random.nextInt(100);
        if ((this.readLinks == null || this.readLinks.isEmpty()) && (this.writeLinks == null || this.writeLinks.isEmpty())) {
            throw new RuntimeException("GET and POST links empty");
        }
        RequestPlan chosen;
        if (this.readLinks == null || this.readLinks.isEmpty()) {
            probability = 100;
        } else if (this.writeLinks == null || this.writeLinks.isEmpty()) {
            probability = 0;
        }
        if (probability < 80) {
            int chosenIndex = random.nextInt(this.readLinks.size());
            chosen = this.readLinks.get(chosenIndex);
        } else {
            int chosenIndex = random.nextInt(this.writeLinks.size());
            chosen = this.writeLinks.get(chosenIndex);
        }
        return chosen.build(session);
    }

    public Request build(Session session) {
        Random random = new Random();
        int randomInt = random.nextInt() & Integer.MAX_VALUE;
        if (this.URL == null || this.URL.isEmpty()) {
            throw new RuntimeException("URL is empty");
        }
        String URL = this.URL.replace("$", String.valueOf(randomInt));
        Pattern pattern = Pattern.compile("#\\{(.*?)\\}");
        Matcher originalMatcher = pattern.matcher(this.URL);
        Matcher randomMatcher = pattern.matcher(URL);
        while (originalMatcher.find() && randomMatcher.find()) {
            String originalFound = originalMatcher.group();
            String randomFound = randomMatcher.group();
            URL = URL.replace(randomFound, originalFound);
        }
        Collection<String> storeFields = storeFields()
                .map(storeField -> storeField.replace("$", String.valueOf(randomInt)))
                .collect(Collectors.toList());
        String headers = null;
        if (this.headers != null) {
            headers = this.headers.replace("$", String.valueOf(randomInt));
            if (this.headers.contains("multipart")) {
                String forms = this.forms;
                return new MultipartRequest(this, session, URL, headers, forms, storeFields);
            }
        }
        if (this.method.equals("DELETE")) {
            return new DeleteRequest(this, session, URL, headers, storeFields);
        }
        if (this.method.equals("GET")) {
            return new GetRequest(this, session, URL, headers, storeFields);
        }
        String data = this.data.replace("$", String.valueOf(randomInt));;
        return new PostRequest(this, session, URL, data, headers, storeFields);
    }

    public Request bind(Request request, Session session) {
        if (request instanceof DeleteRequest) {
            DeleteRequest deleteRequest = (DeleteRequest) request;
            return new DeleteRequest(this, session, deleteRequest.getURL(), deleteRequest.getHeaders(), deleteRequest.getStoreFields());
        }
        if (request instanceof GetRequest) {
            GetRequest getRequest = (GetRequest) request;
            return new GetRequest(this, session, getRequest.getURL(), getRequest.getHeaders(), getRequest.getStoreFields());
        }
        if (request instanceof PostRequest) {
            PostRequest postRequest = (PostRequest) request;
            return new PostRequest(this, session, postRequest.getURL(), postRequest.getData(), postRequest.getHeaders(), postRequest.getStoreFields());
        }
        MultipartRequest multipartRequest = (MultipartRequest) request;
        return new MultipartRequest(this, session, multipartRequest.getURL(), multipartRequest.getHeaders(), multipartRequest.getForms(), multipartRequest.getStoreFields());
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.method, this.URL);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RequestPlan)) {
            return false;
        }
        RequestPlan other = (RequestPlan) obj;
        return this.method.equals(other.method) && this.URL.equals(other.URL);
    }
}
