/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package br.ufrgs.inf.prosoft.requestssimulator;

import br.ufrgs.inf.prosoft.requestssimulator.requests.DeleteRequest;
import br.ufrgs.inf.prosoft.requestssimulator.requests.GetRequest;
import br.ufrgs.inf.prosoft.requestssimulator.requests.PostRequest;
import br.ufrgs.inf.prosoft.requestssimulator.requests.MultipartRequest;
import br.ufrgs.inf.prosoft.requestssimulator.requests.Request;
import br.ufrgs.inf.prosoft.requestssimulator.requests.RequestPlan;
import com.google.gson.Gson;
import com.google.gson.JsonParser;
import java.util.logging.Level;
import java.util.logging.Logger;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.util.ArrayList;
import java.util.Collection;

/**
 *
 * @author romulo
 */
public class LogExecutor {

    private static final Logger LOGGER = Logger.getLogger(LogExecutor.class.getName());

    public static void execute(Profile profile, String tracePath) {
        FileReader fileReader = null;
        try {
            fileReader = new FileReader(tracePath);
        } catch (FileNotFoundException ex) {
            Logger.getLogger(ProfileReader.class.getName()).log(Level.SEVERE, "File not found");
            System.exit(1);
        }
        Collection<Thread> threads = new ArrayList<>();
        JsonParser jsonParser = new JsonParser();
        JsonElement parse = jsonParser.parse(fileReader);
        JsonArray users = parse.getAsJsonArray();
        Gson gson = new Gson();
        users.forEach(user -> {
            Thread thread = new Thread(() -> {
                JsonArray sessions = user.getAsJsonArray();
                Session session = profile.newSession();
                sessions.forEach(sessionExecution -> {
                    JsonArray requests = sessionExecution.getAsJsonArray();
                    requests.forEach(requestJson -> {
                        JsonObject jsonObject = requestJson.getAsJsonObject();
                        String requestPlanReference = jsonObject.get("reference").getAsString();
                        RequestPlan requestPlan = profile.getRequestPlan(requestPlanReference);
                        if (requestPlan == null) {
                            throw new RuntimeException("Request Plan not found");
                        }
                        Request request;
                        if (requestPlan.getMethod().equals("GET")) {
                            request = gson.fromJson(jsonObject, GetRequest.class);
                        } else if (requestPlan.getMethod().equals("DELETE")) {
                            request = gson.fromJson(jsonObject, DeleteRequest.class);
                        } else {
                            JsonElement headers = jsonObject.get("headers");
                            if (headers != null && headers.getAsString().contains("multipart")) {
                                request = gson.fromJson(jsonObject, MultipartRequest.class);
                            } else {
                                request = gson.fromJson(jsonObject, PostRequest.class);
                            }
                        }
                        request = requestPlan.bind(request, session);
                        request.fire();
                    });
                });
            });
            threads.add(thread);
            thread.start();
        });
        threads.forEach((thread) -> {
            try {
                thread.join();
            } catch (InterruptedException ex) {
                LOGGER.log(Level.SEVERE, null, ex);
            }
        });
    }
}
