/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package br.ufrgs.inf.prosoft.requestssimulator;

import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.List;
import java.util.stream.Collectors;

/**
 *
 * @author romulo
 */
public class Executor {

    private static final Logger LOGGER = Logger.getLogger(Executor.class.getName());

    public static final void execute(List<Profile> profiles) {
        List<Thread> threads = profiles.stream().map(profile -> new Thread(() -> {
            profile.execute();
        })).collect(Collectors.toList());
        threads.forEach(Thread::start);
        threads.forEach(thread -> {
            try {
                thread.join();
            } catch (InterruptedException ex) {
                LOGGER.log(Level.SEVERE, null, ex);
            }
        });
    }
}
