/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package br.ufrgs.inf.prosoft.requestssimulator;

import br.ufrgs.inf.prosoft.requestssimulator.requests.Request;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;

/**
 *
 * @author romulo
 */
public class Main {

    public static void main(String[] args) {
        System.setProperty("java.util.logging.SimpleFormatter.format", "[%1$tF %1$tT+%1$tL] [%4$-7s] [RequestsSimulator] %5$s %n");

        if (args.length < 2) {
            System.err.println("--profile=<ProfilePath> --time=<time> [--users=<users>] [--log=<LogPath>] [--throughput=<ThroughputPath>] [--host=<host>] [--home=<homePath>]");
            System.err.println("--profile=<ProfilePath> --execute=<LogPath> [--throughput=<ThroughputPath>] [--host=<host>] [--home=<homePath>]");
            System.err.println("--throughput=<ThroughputPath> --reduce=<ReducePath> --prefix=<prefix>");
            System.exit(1);
        }

        Map<String, String> arguments = Stream.of(args).map(arg -> {
            arg = arg.replaceFirst("--", "");
            int indexOf = arg.indexOf("=");
            if (indexOf == -1) {
                return new String[]{arg, ""};
            }
            return new String[]{arg.substring(0, indexOf), arg.substring(indexOf + 1)};
        }).collect(Collectors.toMap(array -> {
            return array[0];
        }, array -> {
            return array[1];
        }));

        String reducePath = arguments.get("reduce");
        String throughputPath = arguments.get("throughput");
        String prefix = arguments.get("prefix");
        if (reducePath != null) {
            if (throughputPath == null) {
                System.err.println("<ThroughputPath> is required");
                System.exit(1);
            }
            if (prefix == null) {
                System.err.println("<prefix> is required");
                System.exit(1);
            }
            Reducer.reduce(throughputPath, reducePath, prefix);
            System.exit(0);
        }

        String host = arguments.get("host");
        if (host == null) {
            host = "localhost";
        }

        String profilePath = arguments.get("profile");
        if (profilePath == null) {
            System.err.println("<profile> is required");
            System.exit(1);
        }
        Profile profile = ProfileReader.parseFile(profilePath, host);

        String homePath = arguments.get("home");
        if (homePath != null) {
            Request.HOME_PATH = homePath;
        }

        Request.REQUESTS_LOG = throughputPath;
        String logPath = arguments.get("execute");
        if (logPath != null) {
            List<Profile> profiles = LogReader.parseFile(logPath, profile);
            Executor.execute(profiles);
            System.exit(0);
        }

        long time = 0;
        try {
            time = Long.valueOf(arguments.get("time"));
        } catch (NumberFormatException ex) {
            System.err.println("<time> must be a number");
            System.exit(1);
        }
        int users = 1;
        try {
            users = Integer.valueOf(arguments.get("users"));
        } catch (NumberFormatException ex) {
            System.out.println("<users> not informed. Using default " + users);
        }
        logPath = arguments.get("log");
        Simulator.simulate(profile, time, users, logPath);
    }
}
