/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package br.ufrgs.inf.prosoft.requestssimulator;

import java.io.IOException;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.function.Consumer;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Stream;

/**
 *
 * @author romulo
 */
public class Main {

    private static final Logger logger = Logger.getLogger(Main.class.getName());

    public static void main(String[] args) {
        System.setProperty("java.util.logging.SimpleFormatter.format", "[%1$tF %1$tT+%1$tL] [%4$-7s] [RequestsSimulator] %5$s %n");

        String path = null;
        if (args.length < 1) {
            System.err.println("<RequestsPath>");
            System.exit(1);
        } else {
            path = args[0];
        }

        try (Stream<String> lines = Files.lines(Paths.get(path))) {
            long count = Files.lines(Paths.get(path)).count();
            logger.log(Level.INFO, "requesting {0} URLS", count);
            lines.forEach(new Consumer<String>() {
                private int i = 1;

                @Override
                public void accept(String line) {
                    try {
                        if (line.startsWith("POST")) {
                            String[] split = line.split(" ");
                            URL url = new URL(split[1]);
                            HttpURLConnection connection = (HttpURLConnection) url.openConnection();
                            connection.setRequestMethod("POST");
                            connection.setDoOutput(true);
                            try (OutputStream outputStream = connection.getOutputStream()) {
                                outputStream.write(split[2].getBytes());
                            }
                            int responseCode = connection.getResponseCode();
                            if (responseCode == 200) {
                                logger.log(Level.INFO, "{0} {1}", new Object[]{i, line});
                            } else {
                                logger.log(Level.SEVERE, "{0} error {1} on {2}", new Object[]{i, responseCode, line});
                            }
                            connection.disconnect();
                        } else {
                            URL url = new URL(line);
                            HttpURLConnection connection = (HttpURLConnection) url.openConnection();
                            connection.setRequestMethod("GET");
                            int responseCode = connection.getResponseCode();
                            if (responseCode == 200) {
                                logger.log(Level.INFO, "{0} GET {1}", new Object[]{i, line});
                            } else {
                                logger.log(Level.SEVERE, "{0} error {1} on {2}", new Object[]{i, responseCode, line});
                            }
                            connection.disconnect();
                        }
                    } catch (MalformedURLException ex) {
                        logger.log(Level.SEVERE, "Malormed URL");
                    } catch (IOException ex) {
                        logger.log(Level.SEVERE, "IOException");
                    }
                    i++;
                }
            });
        } catch (IOException ex) {
            logger.log(Level.SEVERE, "cannot open file {0}", path);
        }
    }
}
