/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package br.ufrgs.inf.prosoft.requestssimulator;

import java.util.logging.Logger;

/**
 *
 * @author romulo
 */
public class Main {

    private static final Logger logger = Logger.getLogger(Main.class.getName());

    public static void main(String[] args) {
        System.setProperty("java.util.logging.SimpleFormatter.format", "[%1$tF %1$tT+%1$tL] [%4$-7s] [RequestsSimulator] %5$s %n");

        String profilePath = null;
        String tracePath = null;
        long time = 0;
        int users = 1;
        if (args.length < 2) {
            System.err.println("<ProfilePath> <time> [<users>]");
            System.err.println("<ProfilePath> <TracePath>");
            System.exit(1);
        } else {
            profilePath = args[0];
            try {
                time = Long.valueOf(args[1]);
            } catch (NumberFormatException ex) {
                if (args.length == 3) {
                    System.err.println("<time> must be a number");
                    System.exit(1);
                } else {
                    tracePath = args[1];
                }
            }
            if (args.length == 3) {
                try {
                    users = Integer.valueOf(args[2]);
                } catch (NumberFormatException ex) {
                    System.err.println("<users> must be a number");
                    System.exit(1);
                }
            }
        }
        Profile profile = ProfileReader.parseFile(profilePath);
        if (tracePath == null) {
            Simulator.simulate(profile, time, users);
        } else {
            LogExecutor.execute(profile, tracePath);
        }
    }
}
