/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package br.ufrgs.inf.prosoft.requestssimulator.requests;

import br.ufrgs.inf.prosoft.requestssimulator.Session;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collection;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;

/**
 *
 * @author romulo
 */
public class DeleteRequest extends Request {

    protected DeleteRequest(RequestPlan requestPlan, Session session, String URL) {
        super(requestPlan, session, URL);
    }

    protected DeleteRequest(RequestPlan requestPlan, Session session, String URL, String headers) {
        super(requestPlan, session, URL, headers);
    }

    protected DeleteRequest(RequestPlan requestPlan, Session session, String URL, String headers, Collection<String> storeFields) {
        super(requestPlan, session, URL, headers, storeFields);
    }

    @Override
    public void fireRequest() {
        HttpURLConnection httpURLConnection = null;
        try {
            String stringURL = fillPropertyVariable(getURL());
            URL url = new URL(stringURL);
            HttpURLConnection connection = (HttpURLConnection) url.openConnection();
            httpURLConnection = connection;
            connection.setRequestMethod("DELETE");
            headers().forEach(entry -> {
                String value = fillPropertyVariable(entry.getValue());
                connection.setRequestProperty(entry.getKey(), value);
            });
            int responseCode = connection.getResponseCode();
            if (responseCode < 400) {
                Logger.getGlobal().log(Level.INFO, "{0} on {1} {2}", new Object[]{responseCode, getMethod(), stringURL});
                List<String> setCookies = connection.getHeaderFields().get("Set-Cookie");
                storeCookies(setCookies);
                try (BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(connection.getInputStream()))) {
                    String response = bufferedReader.lines().collect(Collectors.joining());
                    processResponse(response);
                }
            } else {
                Logger.getGlobal().log(Level.SEVERE, "error {0} on {1} {2}", new Object[]{responseCode, getMethod(), stringURL});
            }
        } catch (MalformedURLException ex) {
            Logger.getGlobal().log(Level.SEVERE, "Malormed URL");
        } catch (IOException ex) {
            Logger.getGlobal().log(Level.SEVERE, "IOException");
        } catch (Exception ex) {
            ex.printStackTrace();
        } finally {
            if (httpURLConnection != null) {
                httpURLConnection.disconnect();
            }
        }
    }
}
