/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package br.ufrgs.inf.prosoft.requestssimulator;

import br.ufrgs.inf.prosoft.requestssimulator.requests.RequestPlan;

import java.util.*;
import java.util.stream.Stream;

/**
 * @author romulo
 */
public class Profile {

  private final Collection<RequestPlan> roots;
  private final Map<String, RequestPlan> urlHasRequestPlan;
  private final List<Session> sessions;

  public Profile(Map<String, RequestPlan> urlHasRequestPlan) {
    this.urlHasRequestPlan = urlHasRequestPlan;
    Map<String, RequestPlan> rootsReferences = new HashMap<>(this.urlHasRequestPlan);
    this.urlHasRequestPlan.forEach((reference, requestPlan) -> {
      if (reference.charAt(0) == '*') {
        rootsReferences.remove(reference);
        return;
      }
      if (requestPlan.links().count() == 0) {
        rootsReferences.remove(reference);
        return;
      }
      requestPlan.links().forEach(linkReference -> rootsReferences.remove(linkReference.getReference()));
    });
    this.roots = rootsReferences.values();
    this.sessions = new ArrayList<>();
  }

  public Profile(List<Session> sessions) {
    this.sessions = sessions;
    this.roots = null;
    this.urlHasRequestPlan = null;
  }

  public Stream<Session> sessions() {
    return this.sessions.stream();
  }

  public Session newSession() {
    Session session = new Session(this.roots);
    this.sessions.add(session);
    return session;
  }

  public RequestPlan getRequestPlan(String requestPlanReference) {
    return this.urlHasRequestPlan.get(requestPlanReference);
  }

  public void simulate(long time) {
    long end = System.currentTimeMillis() + time;
    while (System.currentTimeMillis() < end) newSession().simulate();
  }

  public void execute() {
    for (Iterator<Session> iterator = this.sessions.iterator(); iterator.hasNext(); ) {
      Session session = iterator.next();
      session.execute();
      iterator.remove();
    }
  }

  @Override
  protected Profile clone() {
    return new Profile(this.urlHasRequestPlan);
  }
}
