/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package br.ufrgs.inf.prosoft.requestssimulator;

import br.ufrgs.inf.prosoft.requestssimulator.requests.DeleteRequest;
import br.ufrgs.inf.prosoft.requestssimulator.requests.GetRequest;
import br.ufrgs.inf.prosoft.requestssimulator.requests.PostRequest;
import br.ufrgs.inf.prosoft.requestssimulator.requests.MultipartRequest;
import br.ufrgs.inf.prosoft.requestssimulator.requests.PutRequest;
import br.ufrgs.inf.prosoft.requestssimulator.requests.Request;
import br.ufrgs.inf.prosoft.requestssimulator.requests.RequestPlan;
import com.google.gson.Gson;
import com.google.gson.JsonParser;
import java.util.logging.Level;
import java.util.logging.Logger;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.util.ArrayList;
import java.util.List;

/**
 *
 * @author romulo
 */
public class LogReader {

    private static final Logger LOGGER = Logger.getLogger(LogReader.class.getName());

    public static List<Profile> parseFile(String logPath, Profile profile) {
        FileReader fileReader = null;
        try {
            fileReader = new FileReader(logPath);
        } catch (FileNotFoundException ex) {
            LOGGER.log(Level.SEVERE, "File not found");
            System.exit(1);
        }
        List<Profile> profiles = new ArrayList<>();
        Gson gson = new Gson();
        JsonParser jsonParser = new JsonParser();
        JsonElement logJson = jsonParser.parse(fileReader);
        JsonArray usersJsonArray = logJson.getAsJsonArray();
        usersJsonArray.forEach(userJson -> {
            List<Session> sessions = new ArrayList<>();
            Profile clone = new Profile(sessions);
            profiles.add(clone);
            JsonArray sessionsJsonArray = userJson.getAsJsonArray();
            sessionsJsonArray.forEach(sessionJson -> {
                JsonArray requestsJsonArray = sessionJson.getAsJsonArray();
                List<Request> requests = new ArrayList<>();
                Session session = new Session(requests);
                sessions.add(session);
                requestsJsonArray.forEach(requestJson -> {
                    JsonObject jsonObject = requestJson.getAsJsonObject();
                    String requestPlanReference = jsonObject.get("reference").getAsString();
                    RequestPlan requestPlan = profile.getRequestPlan(requestPlanReference);
                    if (requestPlan == null) {
                        throw new RuntimeException("Request Plan not found");
                    }
                    Request request;
                    if (requestPlan.getMethod().equals("GET")) {
                        request = gson.fromJson(jsonObject, GetRequest.class);
                    } else if (requestPlan.getMethod().equals("DELETE")) {
                        request = gson.fromJson(jsonObject, DeleteRequest.class);
                    } else if (requestPlan.getMethod().equals("PUT")) {
                        request = gson.fromJson(jsonObject, PutRequest.class);
                    } else {
                        JsonElement headers = jsonObject.get("headers");
                        if (headers != null && headers.getAsString().contains("multipart")) {
                            request = gson.fromJson(jsonObject, MultipartRequest.class);
                        } else {
                            request = gson.fromJson(jsonObject, PostRequest.class);
                        }
                    }
                    request = requestPlan.bind(request, session);
                    requests.add(request);
                });
            });
        });
        return profiles;
    }
}
