/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package br.ufrgs.inf.prosoft.tfcache;

import br.ufrgs.inf.prosoft.tfcache.adapter.TraceReader;
import br.ufrgs.inf.prosoft.tfcache.configuration.Configuration;
import br.ufrgs.inf.prosoft.tfcache.metadata.Method;
import br.ufrgs.inf.prosoft.trace.Trace;

import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

/**
 * @author romulo
 */
public class Main {

    private static final Logger LOGGER = Logger.getLogger(Main.class.getName());

    public static void main(String[] args) {
        System.setProperty("java.util.logging.SimpleFormatter.format", "[%1$tF %1$tT+%1$tL] [%4$-7s] [TFCache] %5$s %n");

        if (args.length < 1) {
            System.err.println("--trace=<TracePath> " +
                    "[--store=<storePath>] " +
                    "[--level=<method|input>] " +
                    "[--output=<outputPath>] " +
                    "[--changeability=<allow|deny>] " +
                    "[--staleness=<ignore|shrink>] " +
                    "[--kernel=<exhaustive|optimised>|test] " +
                    "[--preferences=(savedTime)0..1,0..1(idleTime)] " +
                    "[--verbose=<false|true>]");
            System.exit(1);
        }

        Configuration.process(args);

        LOGGER.log(Level.INFO, "Reading traces");
        List<Trace> traces = TraceReader.parseFile(Configuration.getInput());
        LOGGER.log(Level.INFO, "Grouping {0} traces by methods", traces.size());
        List<Method> methods = TraceReader.groupByMethods(traces);
        StorageManager.load();
        TFCache tfCache = new TFCache(methods);
        tfCache.recommend();
        StorageManager.update();
    }
}
