/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package br.ufrgs.inf.prosoft.tfcache.metadata;

import br.ufrgs.inf.prosoft.tfcache.Metrics;
import br.ufrgs.inf.prosoft.tfcache.Pareto;
import br.ufrgs.inf.prosoft.tfcache.Simulator;
import br.ufrgs.inf.prosoft.tfcache.configuration.Configuration;

import java.math.BigDecimal;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Stream;

/**
 *
 * @author romulo
 */
public class GroupOfOccurrences {

    private static final Logger LOGGER = Logger.getLogger(GroupOfOccurrences.class.getName());

    private final List<Occurrence> occurrences;
    private final String parameters;

    private Pareto pareto;

    public GroupOfOccurrences(String parameters, List<Occurrence> occurrences) {
        this.parameters = parameters;
        this.occurrences = occurrences;
    }

    public String getParameters() {
        return this.parameters;
    }

    public int getOccurrencesSize() {
        return this.occurrences.size();
    }

    public Metrics getBestMetrics() {
        if (this.pareto == null) {
            throw new RuntimeException("simulation must be executed");
        }
        return this.pareto.getBestMetrics();
    }

    public long getTtl() {
        return getBestMetrics().getTtl();
    }

    public long getHits() {
        return getBestMetrics().getHits();
    }

    public long getStales() {
        return getBestMetrics().getStales();
    }

    public double getSavedTime() {
        return getBestMetrics().getSavedTime();
    }

    public BigDecimal getSavedTimePerTimeInCache() {
        return getBestMetrics().getSavedTimePerTimeInCache();
    }

    public Stream<Occurrence> occurrences() {
        return this.occurrences.stream();
    }

    public boolean isChangeable() {
        Iterator<Occurrence> iterator = this.occurrences.iterator();
        Occurrence first = iterator.next();
        while (iterator.hasNext()) {
            Occurrence next = iterator.next();
            if (!Objects.deepEquals(first.getReturnValue(), next.getReturnValue())) {
                return true;
            }
        }
        return false;
    }

    public void calculateMetrics() {
        if (this.pareto != null) {
            LOGGER.log(Level.WARNING, "metrics already calculated");
        }
        if (this.occurrences.size() < 2) {
            throw new RuntimeException("Not reusable input");
        }
        this.occurrences.sort(Comparator.comparingLong(Occurrence::getStartTime));
        this.pareto = new Pareto();
        Simulator.simulate(this.occurrences, this.pareto);
        if (Configuration.getVerbose()) {
            this.pareto.values().forEach(it ->
                    System.out.println(Configuration.getInput() + "," + it.getTtl() + "," + it.getSavedTime() + "," + it.getHits() + "," + it.getTimeInCache()));
        }
    }

}
