/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package br.ufrgs.inf.prosoft.tfcache.metadata;

import br.ufrgs.inf.prosoft.tfcache.Metrics;
import br.ufrgs.inf.prosoft.tfcache.Simulator;
import java.math.BigDecimal;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Stream;

/**
 *
 * @author romulo
 */
public class GroupOfOccurrences {

    private static final Logger LOGGER = Logger.getLogger(GroupOfOccurrences.class.getName());

    private final List<Occurrence> occurrences;
    private final String parameters;

    private Metrics bestMetrics;

    public GroupOfOccurrences(String parameters, List<Occurrence> occurrences) {
        this.parameters = parameters;
        this.occurrences = occurrences;
    }

    public String getParameters() {
        return this.parameters;
    }

    public int getOccurrencesSize() {
        return this.occurrences.size();
    }

    public Metrics getBestMetrics() {
        if (this.bestMetrics == null) {
            throw new RuntimeException("hitsPerTimeInCache must be calculated");
        }
        return this.bestMetrics;
    }

    public long getTtl() {
        return getBestMetrics().getTtl();
    }

    public long getHits() {
        return getBestMetrics().getHits();
    }

    public long getStales() {
        return getBestMetrics().getStales();
    }

    public long getSavedTime() {
        return getBestMetrics().getSavedTime();
    }

    public BigDecimal getSavedTimePerTimeInCache() {
        return getBestMetrics().getSavedTimePerTimeInCache();
    }

    public Stream<Occurrence> occurrences() {
        return this.occurrences.stream();
    }

    public boolean isChangeable() {
        Iterator<Occurrence> iterator = this.occurrences.iterator();
        Occurrence first = iterator.next();
        while (iterator.hasNext()) {
            Occurrence next = iterator.next();
            if (!Objects.deepEquals(first.getReturnValue(), next.getReturnValue())) {
                return true;
            }
        }
        return false;
    }

    public void calculateHitsPerTimeInCache() {
        if (this.bestMetrics != null) {
            LOGGER.log(Level.WARNING, "HitsPerTimeInCache already calculated");
        }
        if (this.occurrences.size() < 2) {
            throw new RuntimeException("Not reusable input");
        }
        this.occurrences.sort((occurrence1, occurrence2) -> Long.compare(occurrence1.getStartTime(), occurrence2.getStartTime()));
        this.bestMetrics = new Metrics();
        Simulator.simulate(this.occurrences, this.bestMetrics);
    }

}
