/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package br.ufrgs.inf.prosoft.tfcache;

import br.ufrgs.inf.prosoft.tfcache.adapter.TraceReader;
import br.ufrgs.inf.prosoft.tfcache.metadata.Method;
import br.ufrgs.inf.prosoft.trace.Trace;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import java.util.stream.Stream;

/**
 *
 * @author romulo
 */
public class Main {

    private static final Logger LOGGER = Logger.getLogger(Main.class.getName());

    public static void main(String[] args) {
        System.setProperty("java.util.logging.SimpleFormatter.format", "[%1$tF %1$tT+%1$tL] [%4$-7s] [TFCache] %5$s %n");

        if (args.length < 1) {
            System.err.println("--trace=<TracePath>");
            System.err.println("--trace=<TracePath> --level=<method|input> [--output=<outputPath>] [--changeability=<true|false>]");
            System.err.println("--trace=<TracePath> --level=input --output=<outputPath>");
            System.exit(1);
        }

        Map<String, String> arguments = Stream.of(args).map(arg -> {
            arg = arg.replaceFirst("--", "");
            int indexOf = arg.indexOf("=");
            if (indexOf == -1) {
                return new String[]{arg, ""};
            }
            return new String[]{arg.substring(0, indexOf), arg.substring(indexOf + 1)};
        }).collect(Collectors.toMap(array -> {
            return array[0];
        }, array -> {
            return array[1];
        }));

        String tracePath = arguments.get("trace");
        if (tracePath == null) {
            System.err.println("<TracePath> is required");
            System.exit(1);
        }
        String level = arguments.get("level");
        if (level == null) {
            level = "method";
            LOGGER.log(Level.INFO, "Using default level: {0}", level);
        }
        String changeability = arguments.get("changeability");
        if (changeability == null) {
            changeability = "false";
            LOGGER.log(Level.INFO, "Using default changeability: {0}", changeability);
        }
        String output = arguments.get("output");
        if (level.equals("input") && output == null) {
            System.err.println("outputPath is required for input-level recommendations");
            System.exit(1);
        }

        LOGGER.log(Level.INFO, "Reading traces");
        List<Trace> traces = TraceReader.parseFile(tracePath);
        LOGGER.log(Level.INFO, "Grouping {0} traces by methods", traces.size());
        List<Method> methods = TraceReader.groupByMethods(traces);
        TFCache tfCache = new TFCache(methods);
        if (level.equals("input")) {
            tfCache.recommend(changeability.equals("true"), output);
        } else {
            tfCache.recommend(changeability.equals("true"));
        };
    }
}
