/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package br.ufrgs.inf.prosoft.tfcache.metadata;

import br.ufrgs.inf.prosoft.tfcache.Metrics;
import br.ufrgs.inf.prosoft.tfcache.Simulator;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.LongStream;
import java.util.stream.Stream;

/**
 *
 * @author romulo
 */
public class GroupOfOccurrences {

    private static final Logger LOGGER = Logger.getLogger(GroupOfOccurrences.class.getName());

    private final List<Occurrence> occurrences;
    private final String parameters;

    private Metrics bestMetrics;

    public GroupOfOccurrences(String parameters, List<Occurrence> occurrences) {
        this.parameters = parameters;
        this.occurrences = occurrences;
    }

    public String getParameters() {
        return this.parameters;
    }

    public int getOccurrencesSize() {
        return this.occurrences.size();
    }

    public Metrics getBestMetrics() {
        if (this.bestMetrics == null) {
            throw new RuntimeException("hitsPerTimeInCache must be calculated");
        }
        return this.bestMetrics;
    }

    public Long getTtl() {
        return getBestMetrics().getTtl();
    }

    public Long getSavedTime() {
        return getBestMetrics().getSavedTime();
    }

    public Double getHitsPerTimeInCache() {
        return getBestMetrics().getHitsPerTimeInCache();
    }

    public Stream<Occurrence> occurrences() {
        return this.occurrences.stream();
    }

    public boolean isChangeable() {
        Iterator<Occurrence> iterator = this.occurrences.iterator();
        Occurrence first = iterator.next();
        while (iterator.hasNext()) {
            Occurrence next = iterator.next();
            if (!Objects.deepEquals(first.getReturnValue(), next.getReturnValue())) {
                return true;
            }
        }
        return false;
    }

    public void calculateHitsPerTimeInCache() {
        if (this.bestMetrics != null) {
            LOGGER.log(Level.WARNING, "HitsPerTimeInCache already calculated");
        }
        if (this.occurrences.size() < 2) {
            throw new RuntimeException("Not reusable input");
        }
        long maxTTL = this.occurrences.get(this.occurrences.size() - 1).getStartTime() - this.occurrences.get(0).getStartTime();
        this.bestMetrics = new Metrics();
        LongStream.range(1, maxTTL).parallel().forEach(actualTTL -> {
            Simulator.simulate(occurrences(), actualTTL, this.bestMetrics);
        });
    }

}
