/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package br.ufrgs.inf.prosoft.tfcache;

/**
 *
 * @author romulo
 */
public class Metrics implements Comparable<Metrics> {

    private long ttl;
    private long savedTime;
    private double hitsPerTimeInCache;

    public Metrics() {
    }

    public Metrics(long ttl, long savedTime, double hitsPerTimeInCache) {
        this.ttl = ttl;
        this.savedTime = savedTime;
        this.hitsPerTimeInCache = hitsPerTimeInCache;
    }

    public long getTtl() {
        return this.ttl;
    }

    public long getSavedTime() {
        return this.savedTime;
    }

    public double getHitsPerTimeInCache() {
        return this.hitsPerTimeInCache;
    }

    public synchronized void keepBestMetrics(long ttl, long hits, long timeInCache, long savedTime) {
        if (hits == 0) {
            return;
        }
        double hitsPerTimeInCache = (double) (hits) / timeInCache;
        if (this.ttl == 0
                || this.hitsPerTimeInCache < hitsPerTimeInCache
                || (this.hitsPerTimeInCache == hitsPerTimeInCache && this.savedTime < savedTime)
                || (this.hitsPerTimeInCache == hitsPerTimeInCache && this.savedTime == savedTime && this.ttl > ttl)) {
            this.ttl = ttl;
            this.savedTime = savedTime;
            this.hitsPerTimeInCache = hitsPerTimeInCache;
        }
    }

    @Override
    public int compareTo(Metrics other) {
        if (this.hitsPerTimeInCache > other.hitsPerTimeInCache) {
            return 1;
        }
        if (this.hitsPerTimeInCache < other.hitsPerTimeInCache) {
            return -1;
        }
        if (this.savedTime > other.savedTime) {
            return 1;
        }
        if (this.savedTime < other.savedTime) {
            return -1;
        }
        if (this.ttl < other.ttl) {
            return 1;
        }
        if (this.ttl > other.ttl) {
            return -1;
        }
        return 0;
    }

}
