/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package br.ufrgs.inf.prosoft.tfcache;

import br.ufrgs.inf.prosoft.tfcache.metadata.Occurrence;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.stream.Stream;

/**
 *
 * @author romulo
 */
public class Simulator {

    private final Metrics metrics;

    public Simulator() {
        this.metrics = new Metrics();
    }

    public Metrics getMetrics() {
        return metrics;
    }

    public void simulate(Stream<Occurrence> occurrences, long ttl) {
        simulate(occurrences, ttl, this.metrics);
    }

    public static void simulate(Stream<Occurrence> occurrences, long ttl, Metrics metrics) {
        Map<String, Long> inputHasCachedTime = new HashMap<>();

        long actualSavedTime = 0;
        long actualHits = 0;
        long actualTimeInCache = 0;

        Iterator<Occurrence> iterator = occurrences.iterator();
        while (iterator.hasNext()) {
            Occurrence occurrence = iterator.next();
            long adjustedStartTime = occurrence.getStartTime() - actualSavedTime;
            long adjustedEndTime = occurrence.getEndTime() - actualSavedTime;
            if (inputHasCachedTime.containsKey(occurrence.getParametersSerialised()) && adjustedStartTime - inputHasCachedTime.get(occurrence.getParametersSerialised()) > ttl) {
                inputHasCachedTime.remove(occurrence.getParametersSerialised());
            }
            if (inputHasCachedTime.containsKey(occurrence.getParametersSerialised())) {
                actualSavedTime += occurrence.getExecutionTime();
                actualHits++;
            } else {
                inputHasCachedTime.put(occurrence.getParametersSerialised(), adjustedEndTime);
                actualTimeInCache += ttl;
            }
        }
        metrics.keepBestMetrics(ttl, actualHits, actualTimeInCache, actualSavedTime);
    }

}
