package br.ufrgs.inf.prosoft.tfcache.configuration;

import java.util.logging.Level;
import java.util.logging.Logger;

/**
 *
 * @author root
 */
public class Configuration {

    private static final Logger LOGGER = Logger.getLogger(Configuration.class.getName());

    private static String level = "method";
    private static String output = null;
    private static String changeability = "allow";
    private static String staleness = "ignore";
    private static String kernel = "exhaustive";
    private static boolean verbose = false;

    public static void setLevel(String level) {
        if (level == null) {
            LOGGER.log(Level.INFO, "Using default level: {0}", Configuration.level);
            return;
        }
        if (!level.equals("method") && !level.equals("input")) {
            LOGGER.log(Level.SEVERE, "Unrecognised option for level");
            System.exit(1);
        }
        Configuration.level = level;
    }

    public static String getLevel() {
        return level;
    }

    public static void setOutput(String output) {
        if (output == null || output.isBlank()) {
            return;
        }
        Configuration.output = output;
    }

    public static String getOutput() {
        return output;
    }

    public static void setChangeability(String changeability) {
        if (changeability == null) {
            LOGGER.log(Level.INFO, "Using default changeability: {0}", Configuration.changeability);
            return;
        }
        if (!changeability.equals("allow") && !changeability.equals("deny")) {
            LOGGER.log(Level.SEVERE, "Unrecognised option for changeability");
            System.exit(1);
        }
        Configuration.changeability = changeability;
    }

    public static String getChangeability() {
        return changeability;
    }

    public static void setStaleness(String staleness) {
        if (staleness == null) {
            LOGGER.log(Level.INFO, "Using default staleness: {0}", Configuration.staleness);
            return;
        }
        if (!staleness.equals("ignore") && !staleness.equals("shrink")) {
            LOGGER.log(Level.SEVERE, "Unrecognised option for staleness");
            System.exit(1);
        }
        Configuration.staleness = staleness;
    }

    public static String getStaleness() {
        return staleness;
    }

    public static void setKernel(String kernel) {
        if (kernel == null) {
            LOGGER.log(Level.INFO, "Using default kernel: {0}", Configuration.kernel);
            return;
        }
        if (!kernel.equals("exhaustive") && !kernel.equals("optimised") && !kernel.equals("test")) {
            LOGGER.log(Level.SEVERE, "Unrecognised option for kernel");
            System.exit(1);
        }
        Configuration.kernel = kernel;
    }

    public static String getKernel() {
        return kernel;
    }

    public static void setVerbose(String verbose) {
        if (verbose == null) {
            return;
        }
        if (!verbose.equals("true") && !verbose.equals("false")) {
            LOGGER.log(Level.SEVERE, "Unrecognised option for verbose");
            System.exit(1);
        }
        Configuration.verbose = verbose.equals("true");
    }

    public static boolean getVerbose() {
        return verbose;
    }

}
