/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package br.ufrgs.inf.prosoft.tfcache;

import br.ufrgs.inf.prosoft.tfcache.adapter.TraceReader;
import br.ufrgs.inf.prosoft.tfcache.configuration.Configuration;
import br.ufrgs.inf.prosoft.tfcache.metadata.Method;
import br.ufrgs.inf.prosoft.trace.Trace;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import java.util.stream.Stream;

/**
 *
 * @author romulo
 */
public class Main {

    private static final Logger LOGGER = Logger.getLogger(Main.class.getName());

    public static void main(String[] args) {
        System.setProperty("java.util.logging.SimpleFormatter.format", "[%1$tF %1$tT+%1$tL] [%4$-7s] [TFCache] %5$s %n");

        if (args.length < 1) {
            System.err.println("--trace=<TracePath> [--level=<method|input>] [--output=<outputPath>] [--changeability=<allow|deny>] [--staleness=<ignore|shrink>] [--kernel=<exhaustive|optimised>|test] [--verbose=<false|true>]");
            System.exit(1);
        }

        Map<String, String> arguments = Stream.of(args).map(arg -> {
            arg = arg.replaceFirst("--", "");
            int indexOf = arg.indexOf("=");
            if (indexOf == -1) {
                return new String[]{arg, ""};
            }
            return new String[]{arg.substring(0, indexOf), arg.substring(indexOf + 1)};
        }).collect(Collectors.toMap(array -> {
            return array[0];
        }, array -> {
            return array[1];
        }));

        String tracePath = arguments.get("trace");
        if (tracePath == null || tracePath.isBlank()) {
            System.err.println("<TracePath> is required");
            System.exit(1);
        }

        Configuration.setLevel(arguments.get("level"));
        Configuration.setOutput(arguments.get("output"));
        if (Configuration.getLevel().equals("input") && Configuration.getOutput() == null) {
            LOGGER.log(Level.SEVERE, "Output is required for input-level recommendations");
            System.exit(1);
        }
        Configuration.setChangeability(arguments.get("changeability"));
        Configuration.setStaleness(arguments.get("staleness"));
        Configuration.setKernel(arguments.get("kernel"));
        Configuration.setVerbose(arguments.get("verbose"));

        LOGGER.log(Level.INFO, "Reading traces");
        List<Trace> traces = TraceReader.parseFile(tracePath);
        LOGGER.log(Level.INFO, "Grouping {0} traces by methods", traces.size());
        List<Method> methods = TraceReader.groupByMethods(traces);
        TFCache tfCache = new TFCache(methods);
        tfCache.recommend();
    }
}
