package br.ufrgs.inf.prosoft.tfcache;

import br.ufrgs.inf.prosoft.tfcache.configuration.Configuration;
import br.ufrgs.inf.prosoft.tfcache.metadata.Occurrence;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.Iterator;
import java.util.List;
import java.util.function.Supplier;
import java.util.logging.Logger;

public class StorageManager {

    private static final Logger LOGGER = Logger.getLogger(StorageManager.class.getName());
    private static JsonObject STORAGE = null;
    private static String UUID = null;

    public static Metrics get(String uuid, List<Occurrence> occurrences) {
        if (occurrences == null || occurrences.isEmpty() || occurrences.size() < 2) {
            LOGGER.severe("Wrong list of occurrences provided");
            System.exit(1);
        }
        if (Configuration.getStore() == null) {
            return null;
        }
        if (STORAGE == null) {
            load();
        }
        if (STORAGE.get(uuid) == null) {
            return null;
        }
        String batchUUID = getBatchUUID(occurrences);
        JsonElement storedMetrics = STORAGE.get(uuid).getAsJsonObject().get("batches").getAsJsonObject().get(batchUUID);
        Gson gson = new Gson();
        return gson.fromJson(storedMetrics, Metrics.class);
    }

    public static Metrics computeIfAbsent(List<Occurrence> occurrences, Supplier<Metrics> supplier) {
        if (occurrences == null || occurrences.isEmpty() || occurrences.size() < 2) {
            LOGGER.severe("Wrong list of occurrences provided");
            System.exit(1);
        }
        if (Configuration.getStore() == null) {
            return supplier.get();
        }
        if (STORAGE == null) {
            load();
        }
        String batchUUID = getBatchUUID(occurrences);
        JsonElement storedMetrics = STORAGE.get(UUID).getAsJsonObject().get("batches").getAsJsonObject().get(batchUUID);
        Gson gson = new Gson();
        if (storedMetrics != null) {
            return gson.fromJson(storedMetrics, Metrics.class);
        }
        Metrics metrics = supplier.get();
        JsonElement jsonMetrics = gson.toJsonTree(metrics);
        STORAGE.get(UUID).getAsJsonObject().get("batches").getAsJsonObject().add(batchUUID, jsonMetrics);
        return metrics;
    }

    private static String getBatchUUID(List<Occurrence> occurrences) {
        StringBuilder uuid = new StringBuilder();
        Iterator<Occurrence> iterator = occurrences.iterator();
        while (iterator.hasNext()) {
            Occurrence occurrence = iterator.next();
            uuid.append(occurrence.getStartTime()).append(":").append(occurrence.getEndTime());
            if (iterator.hasNext()) {
                uuid.append(",");
            }
        }
        return uuid.toString();
    }

    private static JsonObject loadStorage() {
        FileReader fileReader = null;
        try {
            fileReader = new FileReader(Configuration.getStore());
        } catch (FileNotFoundException ex) {
            Gson gson = new GsonBuilder().setPrettyPrinting().create();
            try (Writer writer = new FileWriter(Configuration.getStore(), true)) {
                gson.toJson(new JsonObject(), writer);
            } catch (IOException ex1) {
            }
            try {
                fileReader = new FileReader(Configuration.getStore());
            } catch (FileNotFoundException ex1) {
            }
        }
        JsonParser jsonParser = new JsonParser();
        JsonObject storage = jsonParser.parse(fileReader).getAsJsonObject();
        return storage;
    }

    public static void load() {
        if (Configuration.getStore() == null) {
            return;
        }
        STORAGE = loadStorage();
        UUID = Configuration.getUUID();
        if (STORAGE.get(UUID) == null) {
            LOGGER.info("Configurations not stored yet");
            STORAGE.add(UUID, new JsonObject());
            STORAGE.get(UUID).getAsJsonObject().add("configuration", Configuration.toJSONObject());
            STORAGE.get(UUID).getAsJsonObject().add("batches", new JsonObject());
        }
    }

    public static void update() {
        if (Configuration.getStore() == null) {
            return;
        }
        JsonObject storage = loadStorage();
        if (storage.get(UUID) == null) {
            storage.add(UUID, STORAGE.get(UUID));
        } else {
            STORAGE.get(UUID).getAsJsonObject().get("batches").getAsJsonObject().entrySet().forEach(entry -> {
                String computedBatchUUID = entry.getKey();
                if (storage.get(UUID).getAsJsonObject().get("batches").getAsJsonObject().get(computedBatchUUID) == null) {
                    storage.get(UUID).getAsJsonObject().get("batches").getAsJsonObject().add(computedBatchUUID, entry.getValue());
                }
            });
        }
        try (Writer writer = new FileWriter(Configuration.getStore())) {
            Gson gson = new GsonBuilder().setPrettyPrinting().create();
            gson.toJson(storage, writer);
        } catch (IOException ex1) {
        }
    }

}
