package br.ufrgs.inf.prosoft.tfcache.configuration;

import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class Arguments {

    public static Map<String, String> parse(String[] args) {
        Map<String, String> arguments = Stream.of(args).map(arg -> {
            arg = arg.replaceFirst("--", "");
            int indexOf = arg.indexOf("=");
            if (indexOf == -1) {
                return new String[]{arg, ""};
            }
            return new String[]{arg.substring(0, indexOf), arg.substring(indexOf + 1)};
        }).collect(Collectors.toMap(array -> {
            return array[0];
        }, array -> {
            return array[1];
        }));
        return arguments;
    }
}
