package br.ufrgs.inf.prosoft.tfcache.metadata;

import com.google.gson.Gson;

public abstract class Occurrence {

    private final String instance;
    private final long startTime;
    private final long endTime;
    private final String userId;

    public Occurrence(String instance, long startTime, long endTime, String userId) {
        this.startTime = startTime;
        this.endTime = endTime;
        this.userId = userId;
        this.instance = instance;
    }

    public String getInstance() {
        return instance;
    }

    public long getStartTime() {
        return startTime;
    }

    public long getEndTime() {
        return endTime;
    }

    public long getExecutionTime() {
        return endTime - startTime;
    }

    public String getUserId() {
        return userId;
    }

    public abstract Object[] getParameters();

    public abstract Object getReturnValue();

    public String getParametersSerialised() {
        Gson gson = new Gson();
        return gson.toJson(getParameters());
    }

}
