/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package br.ufrgs.inf.prosoft.tfcache.metadata;

import br.ufrgs.inf.prosoft.trace.Parameter;
import br.ufrgs.inf.prosoft.trace.Return;
import br.ufrgs.inf.prosoft.trace.reader.Traces;
import java.util.List;
import java.util.stream.Collectors;

/**
 *
 * @author romulo
 */
public class OccurrenceReference extends Occurrence {

    private final int index;

    public OccurrenceReference(int index, String instance, long startTime, long endTime, String userId) {
        super(instance, startTime, endTime, userId);
        this.index = index;
    }

    @Override
    public Object[] getParameters() {
        List<Parameter> parameters = Traces.getTraceParameter(this.index);
        return parameters.stream()
                .map(Parameter::getData)
                .collect(Collectors.toList())
                .toArray();
    }

    @Override
    public Object getReturnValue() {
        Return returnValue = Traces.getTraceReturn(this.index);
        return returnValue == null ? null : returnValue.getData();
    }
}
