/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package br.ufrgs.inf.prosoft.tfcache.adapter;

import br.ufrgs.inf.prosoft.tfcache.metadata.Method;
import br.ufrgs.inf.prosoft.tfcache.metadata.Occurrence;
import br.ufrgs.inf.prosoft.tfcache.metadata.OccurrenceConcrete;
import br.ufrgs.inf.prosoft.tfcache.metadata.OccurrenceReference;
import br.ufrgs.inf.prosoft.trace.Parameter;
import br.ufrgs.inf.prosoft.trace.Trace;
import br.ufrgs.inf.prosoft.trace.TraceReference;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;

/**
 *
 * @author romulo
 */
public class TraceReader extends br.ufrgs.inf.prosoft.trace.reader.TraceReader {

    private static final Logger LOGGER = Logger.getLogger(TraceReader.class.getName());

    public static List<Method> groupByMethods(List<Trace> traces) {
        Map<String, List<Occurrence>> methodHasOccurrences = new HashMap<>();
        while (!traces.isEmpty()) {
            Trace trace = traces.remove(0);
            try {
                Occurrence occurrence;
                if (trace instanceof TraceReference) {
                    TraceReference traceReference = (TraceReference) trace;
                    occurrence = new OccurrenceReference(traceReference.getIndex(), traceReference.getInstance(), trace.getStartTime(), trace.getEndTime(), trace.getUserSession());
                } else {
                    occurrence = new OccurrenceConcrete(trace.getInstance(),
                            trace.getParameters().stream()
                                    .map(Parameter::getData)
                                    .collect(Collectors.toList()).toArray(),
                            trace.getReturn().getData(),
                            trace.getStartTime(),
                            trace.getEndTime(),
                            trace.getUserSession()
                    );
                }
                try {
                    methodHasOccurrences.get(trace.getName()).add(occurrence);
                } catch (Exception ex) {
                    List<Occurrence> occurrences = new ArrayList<>();
                    occurrences.add(occurrence);
                    methodHasOccurrences.put(trace.getName(), occurrences);
                }
            } catch (Exception e) {
                LOGGER.log(Level.INFO, "Trace discarted: {0}", trace);
            }
        }
        return methodHasOccurrences.entrySet().stream()
                .map(entry -> new Method(entry.getKey(), entry.getValue()))
                .collect(Collectors.toList());
    }

}
