package br.ufrgs.inf.prosoft.aplcachetf.extension.metadata;

import br.ufrgs.inf.prosoft.aplcachetf.extension.metrics.Metrics;
import br.ufrgs.inf.prosoft.aplcachetf.extension.metrics.Thresholds;
import br.ufrgs.inf.prosoft.tfcache.Simulator;
import br.ufrgs.inf.prosoft.tfcache.metadata.Occurrence;
import org.apache.commons.lang3.builder.EqualsBuilder;

import java.util.Comparator;
import java.util.List;
import java.util.logging.Logger;
import java.util.stream.Stream;

public class GroupOfOccurrences {

  private static final Logger LOGGER = Logger.getLogger(GroupOfOccurrences.class.getName());

  private final String parameters;
  private final List<Occurrence> occurrences;
  private Metrics metrics;

  public GroupOfOccurrences(String parameters, List<Occurrence> occurrences) {
    this.parameters = parameters;
    this.occurrences = occurrences;
  }

  public String getParameters() {
    return this.parameters;
  }

  public Stream<Occurrence> occurrences() {
    return this.occurrences.stream();
  }

  public Metrics getMetrics() {
    if (this.metrics == null) throw new RuntimeException("Metrics must be calculated");
    return this.metrics;
  }

  protected void calculateMetrics() {
    if (this.metrics != null) LOGGER.warning("Metrics already calculated");
    if (this.occurrences.size() < 2) throw new RuntimeException("Not reusable input");

    this.metrics = new Metrics();

    this.occurrences.sort(Comparator.comparingLong(Occurrence::getStartTime));
    Simulator.simulate(this.occurrences, getMetrics().getPareto());

    for (int i = 0; i < this.occurrences.size(); i++) {
      Occurrence occurrence = this.occurrences.get(i);
      Object returnValue = occurrence.getReturnValue();
      for (int j = i + 1; j < this.occurrences.size(); j++) {
        Occurrence other = this.occurrences.get(j);
        if (EqualsBuilder.reflectionEquals(returnValue, other.getReturnValue())) {
          getMetrics().registerReuse(occurrence);
        } else {
          getMetrics().registerChange();
        }
      }
    }
  }

  protected void calculateThresholds() {
    Thresholds.EXECUTION_TIMES.add(getMetrics().getReusableExecutionTime());
    Thresholds.HIT_RATIOS.add(getMetrics().getHitRatio());
    Thresholds.MISS_RATIOS.add(getMetrics().getMissRatio());
    Thresholds.SHAREABILITIES.add(getMetrics().getShareability());
    Thresholds.DISTANCES.add(getMetrics().getMinEuclideanDistance());
  }

}
