package br.ufrgs.inf.prosoft.aplcachetf.extension.metrics;

import br.ufrgs.inf.prosoft.aplcachetf.extension.metadata.GroupOfOccurrences;

public class CacheabilityMetrics {

    public static int K_STANDARD_DEVIATION = 0;

    public static boolean isStaticData(GroupOfOccurrences groupOfOccurrences) {
        if (groupOfOccurrences.getMetrics().getMinEuclideanDistance() > Thresholds.distanceThreshold(K_STANDARD_DEVIATION)) return false;
        return groupOfOccurrences.getMetrics().getHitRatio() == 100.0;
    }

    public static boolean isNotStaticData(GroupOfOccurrences groupOfOccurrences) {
        return !isStaticData(groupOfOccurrences);
    }

    public static boolean isChangeable(GroupOfOccurrences groupOfOccurrences) {
        return groupOfOccurrences.getMetrics().getMissRatio() > Thresholds.missThreshold(K_STANDARD_DEVIATION);
    }

    public static boolean hasHighSavedTimeAndLowIdleTime(GroupOfOccurrences groupOfOccurrences) {
        return groupOfOccurrences.getMetrics().getMinEuclideanDistance() <= Thresholds.distanceThreshold(K_STANDARD_DEVIATION);
    }

    public static boolean hasLowSavedTimeAndHighIdleTime(GroupOfOccurrences groupOfOccurrences) {
        return !hasHighSavedTimeAndLowIdleTime(groupOfOccurrences);
    }

    public static boolean isUserSpecific(GroupOfOccurrences groupOfOccurrences) {
        if (groupOfOccurrences.getMetrics().getShareableReuses() == 0) return false;
        return groupOfOccurrences.getMetrics().getShareability() < Thresholds.shareabilityThreshold(K_STANDARD_DEVIATION);
    }

    public static boolean isExpensive(GroupOfOccurrences groupOfOccurrences) {
        return groupOfOccurrences.getMetrics().getAverageReusableExecutionTime() >= Thresholds.expensivenessThreshold(K_STANDARD_DEVIATION);
    }

    public static boolean isCheap(GroupOfOccurrences groupOfOccurrences) {
        return !isExpensive(groupOfOccurrences);
    }
}
