package br.ufrgs.inf.prosoft.aplcachetf.extension.metrics;

import br.ufrgs.inf.prosoft.aplcachetf.extension.metadata.GroupOfOccurrences;
import java.util.Optional;

public class CacheabilityMetrics {

    public static int K_STANDARD_DEVIATION = 0;

    public static boolean isStaticData(GroupOfOccurrences groupOfOccurrences) {
        return groupOfOccurrences.getBestMetrics().getNumberOfDifferentReturnOccurrences() == 0;
    }

    public static Optional<Boolean> changeMoreThanUsed(GroupOfOccurrences groupOfOccurrences) {
        //+/- k sds
        return Optional.of(groupOfOccurrences.getBestMetrics().getMissRatio() > Thresholds.missThreshold(K_STANDARD_DEVIATION));
    }

    public static Optional<Boolean> usedByManyRequests(GroupOfOccurrences groupOfOccurrences) {
        return Optional.of(groupOfOccurrences.getBestMetrics().getHitsPerTimeInCache().compareTo(Thresholds.hitsPerTimeInCacheThreshold(K_STANDARD_DEVIATION)) >= 0);
    }

    public static Optional<Boolean> isUserSpecific(GroupOfOccurrences groupOfOccurrences) {
        if (groupOfOccurrences.getBestMetrics().getAmountOfIdentifiedSameOccurences() == 0) {
            return Optional.empty();
        }
        //the less shareable, the more user specific
        return Optional.of(groupOfOccurrences.getBestMetrics().getShareability() < Thresholds.shareabilityThreshold(K_STANDARD_DEVIATION));
    }

    public static Optional<Boolean> isExpensive(GroupOfOccurrences groupOfOccurrences) {
        return Optional.of(groupOfOccurrences.getBestMetrics().getSameOccurrencesAverageExecutionTime() >= Thresholds.expensivenessThreshold(K_STANDARD_DEVIATION));
    }
}
