package br.ufrgs.inf.prosoft.aplcachetf.extension.metrics;

import br.ufrgs.inf.prosoft.aplcachetf.extension.metadata.GroupOfOccurrences;
import java.util.Optional;

public class CacheabilityPatternDecider {

    /**
     * Flowchart definition
     *
     * @param groupOfOccurrences
     * @return
     */
    public static boolean isCacheable(GroupOfOccurrences groupOfOccurrences) {
        //Is the data completely static?
        boolean isStaticData = CacheabilityMetrics.isStaticData(groupOfOccurrences);
        if (isStaticData) { // staticity yes
            return true;
        }
        // staticity no/not sure
        Optional<Boolean> changeMoreThanUsed = CacheabilityMetrics.changeMoreThanUsed(groupOfOccurrences);
        if (changeMoreThanUsed.isPresent() && changeMoreThanUsed.get()) { //changeMoreThanUsed true
            return false;
        }
        //changeMoreThanUsed not/not sure
        Optional<Boolean> usedByManyRequests = CacheabilityMetrics.usedByManyRequests(groupOfOccurrences);
        if (usedByManyRequests.isPresent() && !usedByManyRequests.get()) { //useByManyRequests no
            return false;
        }
        Optional<Boolean> isUserSpecific = CacheabilityMetrics.isUserSpecific(groupOfOccurrences);
        if (isUserSpecific.isPresent() && isUserSpecific.get()) {
            return true;
        }
        Optional<Boolean> isExpensive = CacheabilityMetrics.isExpensive(groupOfOccurrences);
        return isExpensive.isPresent() ? isExpensive.get() : true;
    }

    public static boolean isNotCacheable(GroupOfOccurrences groupOfOccurrences) {
        return !isCacheable(groupOfOccurrences);
    }

}
