/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package br.ufrgs.inf.prosoft.aplcachetf.extension.metadata;

import br.ufrgs.inf.prosoft.aplcachetf.extension.metrics.CacheabilityPatternDecider;
import br.ufrgs.inf.prosoft.tfcache.Metrics;
import br.ufrgs.inf.prosoft.tfcache.metadata.Occurrence;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import java.util.stream.Stream;

/**
 *
 * @author root
 */
public class Method {

    private static final Logger LOGGER = Logger.getLogger(Method.class.getName());

    private final String name;
    private List<Occurrence> occurrences;
    private List<GroupOfOccurrences> groupsOfOccurrences;
    private Metrics bestMetrics;

    public Method(String name, List<Occurrence> occurrences) {
        this.name = name;
        if (occurrences == null) {
            throw new RuntimeException("Occurrences is null");
        }
        if (occurrences.isEmpty()) {
            throw new RuntimeException("Occurrences is empty");
        }
        this.occurrences = occurrences;
    }

    public String getName() {
        return this.name;
    }

    public Metrics getBestMetrics() {
        if (this.bestMetrics == null) {
            throw new RuntimeException("hitsPerTimeInCache must be calculated");
        }
        return this.bestMetrics;
    }

    public Long getTtl() {
        return getBestMetrics().getTtl();
    }

    public Long getSavedTime() {
        return getBestMetrics().getSavedTime();
    }

    public Double getHitsPerTimeInCache() {
        return getBestMetrics().getHitsPerTimeInCache();
    }

    public Stream<Occurrence> occurrences() {
        if (this.occurrences == null) {
            throw new RuntimeException("Occurrences already consumed");
        }
        return this.occurrences.stream();
    }

    public Stream<GroupOfOccurrences> groupsOfOccurrences() {
        if (this.groupsOfOccurrences == null) {
            groupByInput();
        }
        return this.groupsOfOccurrences.stream();
    }

    public int getOccurrencesSize() {
        if (this.occurrences == null) {
            if (this.groupsOfOccurrences == null) {
                throw new RuntimeException("groupsOfOccurrences is null");
            }
            return this.groupsOfOccurrences.stream().map(GroupOfOccurrences::getOccurrencesSize).reduce(Integer::sum).orElse(0);
        }
        return this.occurrences.size();
    }

    private void groupByInput() {
        if (this.occurrences == null) {
            throw new RuntimeException("Occurrences already consumed");
        }
        Map<String, List<Occurrence>> inputHasOccurrences = new ConcurrentHashMap<>();
        occurrences().forEach(occurrence -> {
            String parameters = occurrence.getParametersSerialised();
            inputHasOccurrences.compute(parameters, (key, oldValue) -> {
                if (oldValue == null) {
                    oldValue = new ArrayList<>();
                }
                oldValue.add(occurrence);
                return oldValue;
            });
        });
        this.groupsOfOccurrences = inputHasOccurrences.entrySet().stream()
                .map(entry -> new GroupOfOccurrences(entry.getKey(), entry.getValue()))
                .collect(Collectors.toList());
        this.occurrences = null;
    }

    public void calculateMetrics() {
        if (this.groupsOfOccurrences == null) {
            groupByInput();
        }
        this.groupsOfOccurrences.stream().forEach(GroupOfOccurrences::calculateMetrics);
        long savedTime = groupsOfOccurrences().map(GroupOfOccurrences::getSavedTime).reduce(Long::sum).get();
        GroupOfOccurrences max = groupsOfOccurrences().max((group1, group2) -> Long.compare(group1.getSavedTime(), group2.getSavedTime())).get();
        long ttl = max.getTtl();
        double hitsPerTimeInCache = max.getHitsPerTimeInCache();
        this.bestMetrics = new Metrics(ttl, savedTime, hitsPerTimeInCache);
    }

    public void calculateThresholds() {
        this.groupsOfOccurrences.stream().forEach(GroupOfOccurrences::calculateThresholds);
    }

    public void filterCacheableInputs() {
        int initialInputsSize = this.groupsOfOccurrences.size();
        this.groupsOfOccurrences.removeIf(CacheabilityPatternDecider::isNotCacheable);
        int removedInputs = initialInputsSize - this.groupsOfOccurrences.size();
        if (removedInputs > 0) {
            LOGGER.log(Level.INFO, "\tRemoved {0} of {1} uncacheable inputs from method {2}", new Object[]{removedInputs, initialInputsSize, this.name});
        }
        initialInputsSize = this.groupsOfOccurrences.size();
        this.groupsOfOccurrences.removeIf(groupOfOccurrence -> groupOfOccurrence.getTtl() == 0);
        removedInputs = initialInputsSize - this.groupsOfOccurrences.size();
        if (removedInputs > 0) {
            LOGGER.log(Level.INFO, "\tRemoved {0} of {1} single-occurrence inputs from method {2}", new Object[]{removedInputs, initialInputsSize, this.name});
        }
    }

    @Override
    public String toString() {
        return this.name;
    }

}
