package br.ufrgs.inf.prosoft.aplcachetf.extension.metrics;

import br.ufrgs.inf.prosoft.tfcache.Pareto;
import br.ufrgs.inf.prosoft.tfcache.metadata.Occurrence;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.HashSet;
import java.util.Set;

public class Metrics {

  private final Set<String> users;
  private final Pareto pareto;
  private long changeable;
  private long reuses;
  private long shareableReuses;
  private long reusableExecutionTime;
  private BigDecimal normalisedMinEuclideanDistance;

  public Metrics() {
    users = new HashSet<>();
    changeable = 0L;
    reuses = 0L;
    shareableReuses = 0L;
    reusableExecutionTime = 0L;
    pareto = new Pareto();
  }

  public void registerReuse(Occurrence occurrence) {
    reuses++;
    reusableExecutionTime += occurrence.getExecutionTime();
    if (occurrence.getUserId() != null && !occurrence.getUserId().equals("Anonymous")) {
      users.add(occurrence.getUserId());
      shareableReuses++;
    }
  }

  public void registerChange() {
    changeable++;
  }

  public Pareto getPareto() {
    return pareto;
  }

  public long getTtl() {
    return getPareto().getBestMetrics().getTtl();
  }

  public long getSavedTime() {
    return getPareto().getBestMetrics().getSavedTime();
  }

  public BigDecimal getNormalisedMinEuclideanDistance() {
    if (normalisedMinEuclideanDistance == null) normalisedMinEuclideanDistance = getPareto().getNormalisedMinEuclideanDistance();
    return normalisedMinEuclideanDistance;
  }

  public long getReusableExecutionTime() {
    return reusableExecutionTime;
  }

  public double getAverageReusableExecutionTime() {
    if (reuses == 0) return 0;
    return new BigDecimal(getReusableExecutionTime())
      .divide(new BigDecimal(reuses), 5, RoundingMode.HALF_UP)
      .doubleValue();
  }

  public long getComparisons() {
    return reuses + changeable;
  }

  public long getReuses() {
    return reuses;
  }

  public long getChanges() {
    return changeable;
  }

  public double getHitRatio() {
    BigDecimal bd = new BigDecimal(getReuses() * 100);
    return bd.divide(new BigDecimal(getComparisons()), 5, RoundingMode.HALF_UP).doubleValue();
  }

  public double getMissRatio() {
    BigDecimal bd = new BigDecimal(getChanges() * 100);
    return bd.divide(new BigDecimal(getComparisons()), 5, RoundingMode.HALF_UP).doubleValue();
  }

  public double getShareability() {
    long shareableReuses = getShareableReuses();
    if (shareableReuses == 0) {
      return 100;
    }
    BigDecimal bd = new BigDecimal(getUsers() * 100);
    return bd.divide(new BigDecimal(shareableReuses), 5, RoundingMode.HALF_UP).doubleValue();
  }

  public long getShareableReuses() {
    return shareableReuses;
  }

  public int getUsers() {
    return users.size();
  }

  public long getAnonymousReuses() {
    return reuses - shareableReuses;
  }

  @Override
  public String toString() {
    return "{"
      + "\"hitRatio\":" + getHitRatio() + ","
      + "\"missRatio\":" + getMissRatio() + ","
      + "\"shareability\":" + getShareability()
      + "}";
  }

}
