/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package br.ufrgs.inf.prosoft.aplcachetf.extension.metrics;

import br.ufrgs.inf.prosoft.tfcache.metadata.Occurrence;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.HashSet;
import java.util.Set;

/**
 *
 * @author root
 */
public class Metrics {
//exactly same method calls

    private final br.ufrgs.inf.prosoft.tfcache.Metrics tfmetrics;
    private long sameOccurrences;

    //number of same method calls with different return
    private long differentReturnOccurrences;
    private long sameOccurrencesExecutionTime;

    private long amountOfIdentifiedSameOccurences;
    private final Set<String> uniqueUsers;

    public Metrics() {
        sameOccurrences = 0L;
        differentReturnOccurrences = 0L;
        sameOccurrencesExecutionTime = 0L;
        amountOfIdentifiedSameOccurences = 0L;
        uniqueUsers = new HashSet<>();
        this.tfmetrics = new br.ufrgs.inf.prosoft.tfcache.Metrics();
    }

    public br.ufrgs.inf.prosoft.tfcache.Metrics getTfmetrics() {
        return tfmetrics;
    }

    public void addSameOccurrence(Occurrence occurrence) {
        sameOccurrences++;
        addSameOccurrencesTotalExecutionTime(occurrence.getExecutionTime());

        if (occurrence.getUserId() != null && !occurrence.getUserId().equals("Anonymous")) {
            uniqueUsers.add(occurrence.getUserId());
            addIdentifiedSameOccurence();
        }
    }

    public void addDifferentReturnOccurrence() {
        differentReturnOccurrences++;
    }

    private void addSameOccurrencesTotalExecutionTime(Long executionTime) {
        sameOccurrencesExecutionTime += executionTime;
    }

    private void addIdentifiedSameOccurence() {
        amountOfIdentifiedSameOccurences++;
    }

    public long getSameOccurrencesTotalExecutionTime() {
        return sameOccurrencesExecutionTime;
    }

    public double getSameOccurrencesAverageExecutionTime() {
        if (sameOccurrences == 0) {
            return 0;
        }
        return new BigDecimal(getSameOccurrencesTotalExecutionTime())
                .divide(new BigDecimal(sameOccurrences), 5, RoundingMode.HALF_UP)
                .doubleValue();
    }

    public Long getNumberOfOccurrences() {
        return sameOccurrences + differentReturnOccurrences;
    }

    public Long getNumberOfSameOccurrences() {
        return sameOccurrences;
    }

    public Long getNumberOfDifferentReturnOccurrences() {
        return differentReturnOccurrences;
    }

    //from 0% to 100%
    public double getHitRatio() {
        BigDecimal bd = new BigDecimal(getNumberOfSameOccurrences() * 100);
        return bd.divide(new BigDecimal(getNumberOfOccurrences()), 5, RoundingMode.HALF_UP).doubleValue();
    }

    //from 0% to 100%
    public double getMissRatio() {
        BigDecimal bd = new BigDecimal(getNumberOfDifferentReturnOccurrences() * 100);
        return bd.divide(new BigDecimal(getNumberOfOccurrences()), 5, RoundingMode.HALF_UP).doubleValue();
    }

    public double getShareability() {
        Long amountOfIdentifiedSameOccurences = getAmountOfIdentifiedSameOccurences();
        if (amountOfIdentifiedSameOccurences == 0) {
            return 100;
        }
        BigDecimal bd = new BigDecimal(getAmountOfUniqueIdentifiedSameOccurences() * 100);
        return bd.divide(new BigDecimal(amountOfIdentifiedSameOccurences), 5, RoundingMode.HALF_UP).doubleValue();
    }

    public Long getAmountOfIdentifiedSameOccurences() {
        return amountOfIdentifiedSameOccurences;
    }

    public int getAmountOfUniqueIdentifiedSameOccurences() {
        return uniqueUsers.size();
    }

    public Long getAmountOfAnonymousSameOccurences() {
        return sameOccurrences - amountOfIdentifiedSameOccurences;
    }

    @Override
    public String toString() {
        return "{"
                + "\"hitRatio\":" + getHitRatio() + ","
                + "\"missRatio\":" + getMissRatio() + ","
                + "\"shareability\":" + getShareability()
                + "}";
    }

}
