/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package br.ufrgs.inf.prosoft.aplcachetf.extension.metadata;

import br.ufrgs.inf.prosoft.aplcachetf.extension.metrics.Metrics;
import br.ufrgs.inf.prosoft.aplcachetf.extension.metrics.Thresholds;
import br.ufrgs.inf.prosoft.tfcache.Simulator;
import br.ufrgs.inf.prosoft.tfcache.metadata.Occurrence;
import java.math.BigDecimal;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Stream;
import org.apache.commons.lang3.builder.EqualsBuilder;

/**
 *
 * @author root
 */
public class GroupOfOccurrences {

    private static final Logger LOGGER = Logger.getLogger(GroupOfOccurrences.class.getName());

    private final String parameters;
    private final List<Occurrence> occurrences;
    private Metrics bestMetrics;

    public GroupOfOccurrences(String parameters, List<Occurrence> occurrences) {
        this.parameters = parameters;
        this.occurrences = occurrences;
    }

    public String getParameters() {
        return this.parameters;
    }

    public Stream<Occurrence> occurrences() {
        return this.occurrences.stream();
    }

    public int getOccurrencesSize() {
        return this.occurrences.size();
    }

    public Metrics getBestMetrics() {
        if (this.bestMetrics == null) {
            throw new RuntimeException("SavedTimePerTimeInCache must be calculated");
        }
        return this.bestMetrics;
    }

    public long getTtl() {
        return getBestMetrics().getTfmetrics().getTtl();
    }

    public long getHits() {
        return getBestMetrics().getTfmetrics().getHits();
    }

    public long getStales() {
        return getBestMetrics().getTfmetrics().getStales();
    }

    public long getSavedTime() {
        return getBestMetrics().getTfmetrics().getSavedTime();
    }

    public BigDecimal getSavedTimePerTimeInCache() {
        return getBestMetrics().getTfmetrics().getSavedTimePerTimeInCache();
    }

    protected void calculateMetrics() {
        if (this.bestMetrics != null) {
            LOGGER.log(Level.WARNING, "Metrics already calculated");
        }
        if (this.occurrences.size() < 2) {
            throw new RuntimeException("Not reusable input");
        }

        this.bestMetrics = new Metrics();

        this.occurrences.sort((occurrence1, occurrence2) -> Long.compare(occurrence1.getStartTime(), occurrence2.getStartTime()));
        Simulator.simulate(this.occurrences, this.bestMetrics.getTfmetrics());

        for (int i = 0; i < this.occurrences.size(); i++) {
            Occurrence occurrence = this.occurrences.get(i);
            Object returnValue = occurrence.getReturnValue();
            for (int j = i + 1; j < this.occurrences.size(); j++) {
                Occurrence other = this.occurrences.get(j);
                if (EqualsBuilder.reflectionEquals(returnValue, other.getReturnValue())) {
                    this.bestMetrics.addSameOccurrence(occurrence);
                    continue;
                }
                this.bestMetrics.addDifferentReturnOccurrence();
            }
        }
    }

    protected void calculateThresholds() {
        Thresholds.executionTimes.add(this.bestMetrics.getSameOccurrencesTotalExecutionTime());
        Thresholds.hitRatios.add(this.bestMetrics.getHitRatio());
        Thresholds.missRatios.add(this.bestMetrics.getMissRatio());
        Thresholds.shareabilities.add(this.bestMetrics.getShareability());
        Thresholds.savedTimePerTimeInCache.add(this.bestMetrics.getTfmetrics().getSavedTimePerTimeInCache());
    }

}
