package br.ufrgs.inf.prosoft.aplcachetf.extension.metrics;

import br.ufrgs.inf.prosoft.aplcachetf.extension.metadata.GroupOfOccurrences;

public class CacheabilityMetrics {

    public static int K_STANDARD_DEVIATION = 0;

    public static boolean isStaticData(GroupOfOccurrences groupOfOccurrences) {
        if (groupOfOccurrences.getBestMetrics().getTfmetrics().getSavedTimePerTimeInCache().compareTo(Thresholds.savedTimePerTimeInCacheThreshold(K_STANDARD_DEVIATION)) < 0) {
            return false;
        }
        return groupOfOccurrences.getBestMetrics().getHitRatio() == 100.0;
    }

    public static boolean isNotStaticData(GroupOfOccurrences groupOfOccurrences) {
        return !isStaticData(groupOfOccurrences);
    }

    public static boolean changeMoreThanUsed(GroupOfOccurrences groupOfOccurrences) {
        return groupOfOccurrences.getBestMetrics().getMissRatio() > Thresholds.missThreshold(K_STANDARD_DEVIATION);
    }

    public static boolean hasHighUsagePerCaching(GroupOfOccurrences groupOfOccurrences) {
        return groupOfOccurrences.getBestMetrics().getTfmetrics().getSavedTimePerTimeInCache().compareTo(Thresholds.savedTimePerTimeInCacheThreshold(K_STANDARD_DEVIATION)) >= 0;
    }

    public static boolean hasLowUsagePerCaching(GroupOfOccurrences groupOfOccurrences) {
        return !hasHighUsagePerCaching(groupOfOccurrences);
    }

    public static boolean isUserSpecific(GroupOfOccurrences groupOfOccurrences) {
        if (groupOfOccurrences.getBestMetrics().getAmountOfIdentifiedSameOccurences() == 0) {
            return false;
        }
        return groupOfOccurrences.getBestMetrics().getShareability() < Thresholds.shareabilityThreshold(K_STANDARD_DEVIATION);
    }

    public static boolean isExpensive(GroupOfOccurrences groupOfOccurrences) {
        return groupOfOccurrences.getBestMetrics().getSameOccurrencesAverageExecutionTime() >= Thresholds.expensivenessThreshold(K_STANDARD_DEVIATION);
    }

    public static boolean isCheap(GroupOfOccurrences groupOfOccurrences) {
        return !isExpensive(groupOfOccurrences);
    }
}
