package br.ufrgs.inf.prosoft.aplcachetf.extension.metrics;

import br.ufrgs.inf.prosoft.aplcachetf.extension.metadata.GroupOfOccurrences;

public class CacheabilityPatternDecider {

    /**
     * Flowchart definition
     *
     * @param groupOfOccurrences
     * @return
     */
    public static boolean isCacheable(GroupOfOccurrences groupOfOccurrences) {
        boolean isStaticData = CacheabilityMetrics.isStaticData(groupOfOccurrences);
        if (isStaticData) {
            return true;
        }
        boolean changeMoreThanUsed = CacheabilityMetrics.changeMoreThanUsed(groupOfOccurrences);
        if (changeMoreThanUsed) {
            return false;
        }
        boolean hasHighUsagePerCaching = CacheabilityMetrics.hasHighUsagePerCaching(groupOfOccurrences);
        if (!hasHighUsagePerCaching) {
            return false;
        }
        boolean isUserSpecific = CacheabilityMetrics.isUserSpecific(groupOfOccurrences);
        if (isUserSpecific) {
            return true;
        }
        return CacheabilityMetrics.isExpensive(groupOfOccurrences);
    }

    public static boolean isNotCacheable(GroupOfOccurrences groupOfOccurrences) {
        return !isCacheable(groupOfOccurrences);
    }

}
