/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package br.ufrgs.inf.prosoft.aplcachetf;

import br.ufrgs.inf.prosoft.aplcachetf.adapter.TraceReader;
import br.ufrgs.inf.prosoft.aplcachetf.extension.APLCache;
import br.ufrgs.inf.prosoft.aplcachetf.extension.metadata.Method;
import br.ufrgs.inf.prosoft.trace.Trace;
import br.ufrgs.inf.prosoft.trace.reader.Mode;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import java.util.stream.Stream;

/**
 *
 * @author romulo
 */
public class Main {

    private static final Logger LOGGER = Logger.getLogger(Main.class.getName());

    public static void main(String[] args) {
        System.setProperty("java.util.logging.SimpleFormatter.format", "[%1$tF %1$tT+%1$tL] [%4$-7s] [APLCacheTF] %5$s %n");

        if (args.length < 2) {
            System.err.println("--trace=<TracePath> --output=<OutputPath> [--mode=<complete|hashed|partial>] [--k=<kStandardDeviation>] [--window=<windowSize>] [--shift=<shiftTime>]");
            System.exit(1);
        }

        Map<String, String> arguments = Stream.of(args).map(arg -> {
            arg = arg.replaceFirst("--", "");
            int indexOf = arg.indexOf("=");
            if (indexOf == -1) {
                return new String[]{arg, ""};
            }
            return new String[]{arg.substring(0, indexOf), arg.substring(indexOf + 1)};
        }).collect(Collectors.toMap(array -> {
            return array[0];
        }, array -> {
            return array[1];
        }));

        String tracePath = arguments.get("trace");
        if (tracePath == null) {
            System.err.println("<TracePath> is required");
            System.exit(1);
        }
        String outputPath = arguments.get("output");
        if (outputPath == null) {
            System.err.println("<OutputPath> is required");
            System.exit(1);
        }
        String mode = arguments.get("mode");
        if (mode == null) {
            mode = "complete";
            LOGGER.log(Level.INFO, "Using default mode: {0}", mode);
        }
        int k = 0;
        String kStr = arguments.get("k");
        if (kStr == null) {
            LOGGER.log(Level.INFO, "Using default k: {0}", k);
        } else {
            try {
                k = Integer.valueOf(kStr);
            } catch (NumberFormatException ex) {
                System.err.println("<k> must be a number");
                System.exit(1);
            }
        }

        Long window = null;
        try {
            window = Long.valueOf(arguments.get("window"));
        } catch (NumberFormatException ex) {
        }
        Long shift = null;
        try {
            shift = Long.valueOf(arguments.get("shift"));
        } catch (NumberFormatException ex) {
        }

        LOGGER.log(Level.INFO, "Reading traces");
        List<Trace> traces = TraceReader.parseFile(tracePath, Mode.valueOf(mode.toUpperCase()), window, shift);
        LOGGER.log(Level.INFO, "Grouping {0} traces by methods", traces.size());
        List<Method> methods = TraceReader.groupByMethods(traces);
        LOGGER.log(Level.INFO, "grouped traces into {0} methods", methods.size());

        APLCache aplcache = new APLCache(methods);
        aplcache.recommend(k, outputPath);
    }
}
