package br.ufrgs.inf.prosoft.aplcachetf.extension.metrics;

import br.ufrgs.inf.prosoft.aplcachetf.extension.metadata.GroupOfOccurrences;

public class CacheabilityPatternDecider {

  public static boolean isCacheable(GroupOfOccurrences groupOfOccurrences) {
    if (CacheabilityMetrics.isStaticData(groupOfOccurrences)) return true;
    if (CacheabilityMetrics.isChangeable(groupOfOccurrences)) return false;
    if (CacheabilityMetrics.hasLowSavedTimeAndHighIdleTime(groupOfOccurrences)) return false;
    if (CacheabilityMetrics.isUserSpecific(groupOfOccurrences)) return true;
    return CacheabilityMetrics.isExpensive(groupOfOccurrences);
  }

  public static boolean isNotCacheable(GroupOfOccurrences groupOfOccurrences) {
    return !isCacheable(groupOfOccurrences);
  }

}
