/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package br.ufrgs.inf.prosoft.aplcachetf;

import br.ufrgs.inf.prosoft.aplcachetf.adapter.TraceReader;
import br.ufrgs.inf.prosoft.aplcachetf.extension.APLCache;
import br.ufrgs.inf.prosoft.aplcachetf.extension.metadata.Method;
import br.ufrgs.inf.prosoft.tfcache.StorageManager;
import br.ufrgs.inf.prosoft.tfcache.configuration.Arguments;
import br.ufrgs.inf.prosoft.tfcache.configuration.Configuration;
import br.ufrgs.inf.prosoft.trace.Trace;
import br.ufrgs.inf.prosoft.trace.reader.Mode;

import java.text.MessageFormat;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;

/**
 * @author romulo
 */
public class Main {

    private static final Logger LOGGER = Logger.getLogger(Main.class.getName());

    public static void main(String[] args) {
        System.setProperty("java.util.logging.SimpleFormatter.format", "[%1$tF %1$tT+%1$tL] [%4$-7s] [APLCacheTF] %5$s %n");

        if (args.length < 2) {
            System.err.println("--trace=<TracePath>" +
                    " --output=<OutputPath>" +
                    " [--tfstore=<storePath>]" +
                    " [--tfkernel=<exhaustive|optimised>]" +
                    " [--tfstaleness=<ignore|shrink>]" +
                    " [--mode=<complete|hashed|partial>]" +
                    " [--k=<kStandardDeviation>]" +
                    " [--objective=(savedTime)0..1,0..1(idleTime)]" +
                    " [--window=<windowSize>]" +
                    " [--shift=<shiftTime>]");
            System.exit(1);
        }

        Map<String, String> arguments = Arguments.parse(args);

        String tracePath = arguments.get("trace");
        if (tracePath == null) {
            System.err.println("<TracePath> is required");
            System.exit(1);
        }
        String outputPath = arguments.get("output");
        if (outputPath == null) {
            System.err.println("<OutputPath> is required");
            System.exit(1);
        }
        String mode = arguments.get("mode");
        if (mode == null) {
            mode = "complete";
            LOGGER.info(MessageFormat.format("Using default mode: {0}", mode));
        }
        int k = 0;
        String kStr = arguments.get("k");
        if (kStr == null) {
            LOGGER.info(MessageFormat.format("Using default k: {0}", k));
        } else {
            try {
                k = Integer.parseInt(kStr);
            } catch (NumberFormatException ex) {
                System.err.println("<k> must be a number");
                System.exit(1);
            }
        }

        Long window = null;
        try {
            window = Long.valueOf(arguments.get("window"));
        } catch (NumberFormatException ignored) {
        }
        Long shift = null;
        try {
            shift = Long.valueOf(arguments.get("shift"));
        } catch (NumberFormatException ignored) {
        }

        LOGGER.info("Reading traces");
        List<Trace> traces = TraceReader.parseFile(tracePath, Mode.valueOf(mode.toUpperCase()), window, shift);
        LOGGER.info(MessageFormat.format("Grouping {0} traces by methods", traces.size()));
        List<Method> methods = TraceReader.groupByMethods(traces);
        LOGGER.info(MessageFormat.format("grouped traces into {0} methods", methods.size()));

        Configuration.setLevel("input");
        Configuration.setKernel(arguments.get("tfkernel"));
        Configuration.setStaleness(arguments.get("tfstaleness"));
        Configuration.setStore(arguments.get("tfstore"));
        Configuration.setInput(Arrays.stream(tracePath.split("/")).reduce((a, b) -> b).orElse(""));
        Configuration.setPreferences(arguments.get("objective"));
        StorageManager.load();
        APLCache aplcache = new APLCache(methods);
        aplcache.recommend(k, outputPath);
        StorageManager.update();
    }
}
