/*
 * Copyright © 2016-2017 The Thingsboard Authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

import ThingsboardMissingTranslateHandler from './translate-handler';

export default angular.module('thingsboard.locale', [])
    .factory('tbMissingTranslationHandler', ThingsboardMissingTranslateHandler)
    .constant('locales',
        {
            'en_US': {
                "access": {
                    "unauthorized": "Unauthorized",
                    "unauthorized-access": "Unauthorized Access",
                    "unauthorized-access-text": "You should sign in to have access to this resource!",
                    "access-forbidden": "Access Forbidden",
                    "access-forbidden-text": "You haven't access rights to this location!<br/>Try to sign in with different user if you still wish to gain access to this location.",
                    "refresh-token-expired": "Session has expired",
                    "refresh-token-failed": "Unable to refresh session"
                },
                "action": {
                    "activate": "Activate",
                    "suspend": "Suspend",
                    "save": "Save",
                    "saveAs": "Save as",
                    "cancel": "Cancel",
                    "ok": "OK",
                    "delete": "Delete",
                    "add": "Add",
                    "yes": "Yes",
                    "no": "No",
                    "update": "Update",
                    "remove": "Remove",
                    "search": "Search",
                    "assign": "Assign",
                    "unassign": "Unassign",
                    "share": "Share",
                    "make-private": "Make private",
                    "apply": "Apply",
                    "apply-changes": "Apply changes",
                    "edit-mode": "Edit mode",
                    "enter-edit-mode": "Enter edit mode",
                    "decline-changes": "Decline changes",
                    "close": "Close",
                    "back": "Back",
                    "run": "Run",
                    "sign-in": "Sign in!",
                    "edit": "Edit",
                    "view": "View",
                    "create": "Create",
                    "drag": "Drag",
                    "refresh": "Refresh",
                    "undo": "Undo",
                    "copy": "Copy",
                    "paste": "Paste",
                    "copy-reference": "Copy reference",
                    "paste-reference": "Paste reference",
                    "import": "Import",
                    "export": "Export",
                    "share-via": "Share via {{provider}}"
                },
                "aggregation": {
                    "aggregation": "Aggregation",
                    "function": "Data aggregation function",
                    "limit": "Max values",
                    "group-interval": "Grouping interval",
                    "min": "Min",
                    "max": "Max",
                    "avg": "Average",
                    "sum": "Sum",
                    "count": "Count",
                    "none": "None"
                },
                "admin": {
                    "general": "General",
                    "general-settings": "General Settings",
                    "outgoing-mail": "Outgoing Mail",
                    "outgoing-mail-settings": "Outgoing Mail Settings",
                    "system-settings": "System Settings",
                    "test-mail-sent": "Test mail was successfully sent!",
                    "base-url": "Base URL",
                    "base-url-required": "Base URL is required.",
                    "mail-from": "Mail From",
                    "mail-from-required": "Mail From is required.",
                    "smtp-protocol": "SMTP protocol",
                    "smtp-host": "SMTP host",
                    "smtp-host-required": "SMTP host is required.",
                    "smtp-port": "SMTP port",
                    "smtp-port-required": "You must supply a smtp port.",
                    "smtp-port-invalid": "That doesn't look like a valid smtp port.",
                    "timeout-msec": "Timeout (msec)",
                    "timeout-required": "Timeout is required.",
                    "timeout-invalid": "That doesn't look like a valid timeout.",
                    "enable-tls": "Enable TLS",
                    "send-test-mail": "Send test mail"
                },
                "alarm": {
                    "alarm": "Alarm",
                    "alarms": "Alarms",
                    "select-alarm": "Select alarm",
                    "no-alarms-matching": "No alarms matching '{{entity}}' were found.",
                    "alarm-required": "Alarm is required",
                    "alarm-status": "Alarm status",
                    "search-status": {
                        "ANY": "Any",
                        "ACTIVE": "Active",
                        "CLEARED": "Cleared",
                        "ACK": "Acknowledged",
                        "UNACK": "Unacknowledged"
                    },
                    "display-status": {
                        "ACTIVE_UNACK": "Active Unacknowledged",
                        "ACTIVE_ACK": "Active Acknowledged",
                        "CLEARED_UNACK": "Cleared Unacknowledged",
                        "CLEARED_ACK": "Cleared Acknowledged"
                    },
                    "no-alarms-prompt": "No alarms found",
                    "created-time": "Created time",
                    "type": "Type",
                    "severity": "Severity",
                    "originator": "Originator",
                    "originator-type": "Originator type",
                    "details": "Details",
                    "status": "Status",
                    "alarm-details": "Alarm details",
                    "start-time": "Start time",
                    "end-time": "End time",
                    "ack-time": "Acknowledged time",
                    "clear-time": "Cleared time",
                    "severity-critical": "Critical",
                    "severity-major": "Major",
                    "severity-minor": "Minor",
                    "severity-warning": "Warning",
                    "severity-indeterminate": "Indeterminate",
                    "acknowledge": "Acknowledge",
                    "clear": "Clear",
                    "search": "Search alarms",
                    "selected-alarms": "{ count, select, 1 {1 alarm} other {# alarms} } selected",
                    "no-data": "No data to display",
                    "polling-interval": "Alarms polling interval (sec)",
                    "polling-interval-required": "Alarms polling interval is required.",
                    "min-polling-interval-message": "At least 1 sec polling interval is allowed.",
                    "aknowledge-alarms-title": "Acknowledge { count, select, 1 {1 alarm} other {# alarms} }",
                    "aknowledge-alarms-text": "Are you sure you want to acknowledge { count, select, 1 {1 alarm} other {# alarms} }?",
                    "clear-alarms-title": "Clear { count, select, 1 {1 alarm} other {# alarms} }",
                    "clear-alarms-text": "Are you sure you want to clear { count, select, 1 {1 alarm} other {# alarms} }?"
                },
                "alias": {
                    "add": "Add alias",
                    "edit": "Edit alias",
                    "name": "Alias name",
                    "name-required": "Alias name is required",
                    "duplicate-alias": "Alias with same name is already exists.",
                    "filter-type-entity-list": "Entity list",
                    "filter-type-entity-name": "Entity name",
                    "filter-type-state-entity": "Entity from dashboard state",
                    "filter-type-state-entity-description": "Entity taken from dashboard state parameters",
                    "filter-type-asset-type": "Asset type",
                    "filter-type-asset-type-description": "Assets of type '{{assetType}}'",
                    "filter-type-asset-type-and-name-description": "Assets of type '{{assetType}}' and with name starting with '{{prefix}}'",
                    "filter-type-device-type": "Device type",
                    "filter-type-device-type-description": "Devices of type '{{deviceType}}'",
                    "filter-type-device-type-and-name-description": "Devices of type '{{deviceType}}' and with name starting with '{{prefix}}'",
                    "filter-type-relations-query": "Relations query",
                    "filter-type-relations-query-description": "{{entities}} that have {{relationType}} relation {{direction}} {{rootEntity}}",
                    "filter-type-asset-search-query": "Asset search query",
                    "filter-type-asset-search-query-description": "Assets with types {{assetTypes}} that have {{relationType}} relation {{direction}} {{rootEntity}}",
                    "filter-type-device-search-query": "Device search query",
                    "filter-type-device-search-query-description": "Devices with types {{deviceTypes}} that have {{relationType}} relation {{direction}} {{rootEntity}}",
                    "entity-filter": "Entity filter",
                    "resolve-multiple": "Resolve as multiple entities",
                    "filter-type": "Filter type",
                    "filter-type-required": "Filter type is required.",
                    "entity-filter-no-entity-matched": "No entities matching specified filter were found.",
                    "no-entity-filter-specified": "No entity filter specified",
                    "root-state-entity": "Use dashboard state entity as root",
                    "root-entity": "Root entity",
                    "max-relation-level": "Max relation level",
                    "unlimited-level": "Unlimited level",
                    "state-entity": "Dashboard state entity",
                    "all-entities": "All entities",
                    "any-relation": "any"
                },
                "asset": {
                    "asset": "Asset",
                    "assets": "Assets",
                    "management": "Asset management",
                    "view-assets": "View Assets",
                    "add": "Add Asset",
                    "assign-to-customer": "Assign to customer",
                    "assign-asset-to-customer": "Assign Asset(s) To Customer",
                    "assign-asset-to-customer-text": "Please select the assets to assign to the customer",
                    "no-assets-text": "No assets found",
                    "assign-to-customer-text": "Please select the customer to assign the asset(s)",
                    "public": "Public",
                    "assignedToCustomer": "Assigned to customer",
                    "make-public": "Make asset public",
                    "make-private": "Make asset private",
                    "unassign-from-customer": "Unassign from customer",
                    "delete": "Delete asset",
                    "asset-public": "Asset is public",
                    "asset-type": "Asset type",
                    "asset-type-required": "Asset type is required.",
                    "select-asset-type": "Select asset type",
                    "enter-asset-type": "Enter asset type",
                    "any-asset": "Any asset",
                    "no-asset-types-matching": "No asset types matching '{{entitySubtype}}' were found.",
                    "asset-type-list-empty": "No asset types selected.",
                    "asset-types": "Asset types",
                    "name": "Name",
                    "name-required": "Name is required.",
                    "description": "Description",
                    "type": "Type",
                    "type-required": "Type is required.",
                    "details": "Details",
                    "events": "Events",
                    "add-asset-text": "Add new asset",
                    "asset-details": "Asset details",
                    "assign-assets": "Assign assets",
                    "assign-assets-text": "Assign { count, select, 1 {1 asset} other {# assets} } to customer",
                    "delete-assets": "Delete assets",
                    "unassign-assets": "Unassign assets",
                    "unassign-assets-action-title": "Unassign { count, select, 1 {1 asset} other {# assets} } from customer",
                    "assign-new-asset": "Assign new asset",
                    "delete-asset-title": "Are you sure you want to delete the asset '{{assetName}}'?",
                    "delete-asset-text": "Be careful, after the confirmation the asset and all related data will become unrecoverable.",
                    "delete-assets-title": "Are you sure you want to delete { count, select, 1 {1 asset} other {# assets} }?",
                    "delete-assets-action-title": "Delete { count, select, 1 {1 asset} other {# assets} }",
                    "delete-assets-text": "Be careful, after the confirmation all selected assets will be removed and all related data will become unrecoverable.",
                    "make-public-asset-title": "Are you sure you want to make the asset '{{assetName}}' public?",
                    "make-public-asset-text": "After the confirmation the asset and all its data will be made public and accessible by others.",
                    "make-private-asset-title": "Are you sure you want to make the asset '{{assetName}}' private?",
                    "make-private-asset-text": "After the confirmation the asset and all its data will be made private and won't be accessible by others.",
                    "unassign-asset-title": "Are you sure you want to unassign the asset '{{assetName}}'?",
                    "unassign-asset-text": "After the confirmation the asset will be unassigned and won't be accessible by the customer.",
                    "unassign-asset": "Unassign asset",
                    "unassign-assets-title": "Are you sure you want to unassign { count, select, 1 {1 asset} other {# assets} }?",
                    "unassign-assets-text": "After the confirmation all selected assets will be unassigned and won't be accessible by the customer.",
                    "copyId": "Copy asset Id",
                    "idCopiedMessage": "Asset Id has been copied to clipboard",
                    "select-asset": "Select asset",
                    "no-assets-matching": "No assets matching '{{entity}}' were found.",
                    "asset-required": "Asset is required",
                    "name-starts-with": "Asset name starts with"
                },
                "attribute": {
                    "attributes": "Attributes",
                    "latest-telemetry": "Latest telemetry",
                    "attributes-scope": "Entity attributes scope",
                    "scope-latest-telemetry": "Latest telemetry",
                    "scope-client": "Client attributes",
                    "scope-server": "Server attributes",
                    "scope-shared": "Shared attributes",
                    "add": "Add attribute",
                    "key": "Key",
                    "last-update-time": "Last update time",
                    "key-required": "Attribute key is required.",
                    "value": "Value",
                    "value-required": "Attribute value is required.",
                    "delete-attributes-title": "Are you sure you want to delete { count, select, 1 {1 attribute} other {# attributes} }?",
                    "delete-attributes-text": "Be careful, after the confirmation all selected attributes will be removed.",
                    "delete-attributes": "Delete attributes",
                    "enter-attribute-value": "Enter attribute value",
                    "show-on-widget": "Show on widget",
                    "widget-mode": "Widget mode",
                    "next-widget": "Next widget",
                    "prev-widget": "Previous widget",
                    "add-to-dashboard": "Add to dashboard",
                    "add-widget-to-dashboard": "Add widget to dashboard",
                    "selected-attributes": "{ count, select, 1 {1 attribute} other {# attributes} } selected",
                    "selected-telemetry": "{ count, select, 1 {1 telemetry unit} other {# telemetry units} } selected"
                },
                "confirm-on-exit": {
                    "message": "You have unsaved changes. Are you sure you want to leave this page?",
                    "html-message": "You have unsaved changes.<br/>Are you sure you want to leave this page?",
                    "title": "Unsaved changes"
                },
                "contact": {
                    "country": "Country",
                    "city": "City",
                    "state": "State",
                    "postal-code": "Postal code",
                    "postal-code-invalid": "Only digits are allowed.",
                    "address": "Address",
                    "address2": "Address 2",
                    "phone": "Phone",
                    "email": "Email",
                    "no-address": "No address"
                },
                "common": {
                    "username": "Username",
                    "password": "Password",
                    "enter-username": "Enter username",
                    "enter-password": "Enter password",
                    "enter-search": "Enter search"
                },
                "customer": {
                    "customer": "Customer",
                    "customers": "Customers",
                    "management": "Customer management",
                    "dashboard": "Customer Dashboard",
                    "dashboards": "Customer Dashboards",
                    "devices": "Customer Devices",
                    "assets": "Customer Assets",
                    "public-dashboards": "Public Dashboards",
                    "public-devices": "Public Devices",
                    "public-assets": "Public Assets",
                    "add": "Add Customer",
                    "delete": "Delete customer",
                    "manage-customer-users": "Manage customer users",
                    "manage-customer-devices": "Manage customer devices",
                    "manage-customer-dashboards": "Manage customer dashboards",
                    "manage-public-devices": "Manage public devices",
                    "manage-public-dashboards": "Manage public dashboards",
                    "manage-customer-assets": "Manage customer assets",
                    "manage-public-assets": "Manage public assets",
                    "add-customer-text": "Add new customer",
                    "no-customers-text": "No customers found",
                    "customer-details": "Customer details",
                    "delete-customer-title": "Are you sure you want to delete the customer '{{customerTitle}}'?",
                    "delete-customer-text": "Be careful, after the confirmation the customer and all related data will become unrecoverable.",
                    "delete-customers-title": "Are you sure you want to delete { count, select, 1 {1 customer} other {# customers} }?",
                    "delete-customers-action-title": "Delete { count, select, 1 {1 customer} other {# customers} }",
                    "delete-customers-text": "Be careful, after the confirmation all selected customers will be removed and all related data will become unrecoverable.",
                    "manage-users": "Manage users",
                    "manage-assets": "Manage assets",
                    "manage-devices": "Manage devices",
                    "manage-dashboards": "Manage dashboards",
                    "title": "Title",
                    "title-required": "Title is required.",
                    "description": "Description",
                    "details": "Details",
                    "events": "Events",
                    "copyId": "Copy customer Id",
                    "idCopiedMessage": "Customer Id has been copied to clipboard",
                    "select-customer": "Select customer",
                    "no-customers-matching": "No customers matching '{{entity}}' were found.",
                    "customer-required": "Customer is required"
                },
                "datetime": {
                    "date-from": "Date from",
                    "time-from": "Time from",
                    "date-to": "Date to",
                    "time-to": "Time to"
                },
                "dashboard": {
                    "dashboard": "Dashboard",
                    "dashboards": "Dashboards",
                    "management": "Dashboard management",
                    "view-dashboards": "View Dashboards",
                    "add": "Add Dashboard",
                    "assign-dashboard-to-customer": "Assign Dashboard(s) To Customer",
                    "assign-dashboard-to-customer-text": "Please select the dashboards to assign to the customer",
                    "assign-to-customer-text": "Please select the customer to assign the dashboard(s)",
                    "assign-to-customer": "Assign to customer",
                    "unassign-from-customer": "Unassign from customer",
                    "make-public": "Make dashboard public",
                    "make-private": "Make dashboard private",
                    "no-dashboards-text": "No dashboards found",
                    "no-widgets": "No widgets configured",
                    "add-widget": "Add new widget",
                    "title": "Title",
                    "select-widget-title": "Select widget",
                    "select-widget-subtitle": "List of available widget types",
                    "delete": "Delete dashboard",
                    "title-required": "Title is required.",
                    "description": "Description",
                    "details": "Details",
                    "dashboard-details": "Dashboard details",
                    "add-dashboard-text": "Add new dashboard",
                    "assign-dashboards": "Assign dashboards",
                    "assign-new-dashboard": "Assign new dashboard",
                    "assign-dashboards-text": "Assign { count, select, 1 {1 dashboard} other {# dashboards} } to customer",
                    "delete-dashboards": "Delete dashboards",
                    "unassign-dashboards": "Unassign dashboards",
                    "unassign-dashboards-action-title": "Unassign { count, select, 1 {1 dashboard} other {# dashboards} } from customer",
                    "delete-dashboard-title": "Are you sure you want to delete the dashboard '{{dashboardTitle}}'?",
                    "delete-dashboard-text": "Be careful, after the confirmation the dashboard and all related data will become unrecoverable.",
                    "delete-dashboards-title": "Are you sure you want to delete { count, select, 1 {1 dashboard} other {# dashboards} }?",
                    "delete-dashboards-action-title": "Delete { count, select, 1 {1 dashboard} other {# dashboards} }",
                    "delete-dashboards-text": "Be careful, after the confirmation all selected dashboards will be removed and all related data will become unrecoverable.",
                    "unassign-dashboard-title": "Are you sure you want to unassign the dashboard '{{dashboardTitle}}'?",
                    "unassign-dashboard-text": "After the confirmation the dashboard will be unassigned and won't be accessible by the customer.",
                    "unassign-dashboard": "Unassign dashboard",
                    "unassign-dashboards-title": "Are you sure you want to unassign { count, select, 1 {1 dashboard} other {# dashboards} }?",
                    "unassign-dashboards-text": "After the confirmation all selected dashboards will be unassigned and won't be accessible by the customer.",
                    "public-dashboard-title": "Dashboard is now public",
                    "public-dashboard-text": "Your dashboard <b>{{dashboardTitle}}</b> is now public and accessible via next public <a href='{{publicLink}}' target='_blank'>link</a>:",
                    "public-dashboard-notice": "<b>Note:</b> Do not forget to make related devices public in order to access their data.",
                    "make-private-dashboard-title": "Are you sure you want to make the dashboard '{{dashboardTitle}}' private?",
                    "make-private-dashboard-text": "After the confirmation the dashboard will be made private and won't be accessible by others.",
                    "make-private-dashboard": "Make dashboard private",
                    "socialshare-text": "'{{dashboardTitle}}' powered by ThingsBoard",
                    "socialshare-title": "'{{dashboardTitle}}' powered by ThingsBoard",
                    "select-dashboard": "Select dashboard",
                    "no-dashboards-matching": "No dashboards matching '{{entity}}' were found.",
                    "dashboard-required": "Dashboard is required.",
                    "select-existing": "Select existing dashboard",
                    "create-new": "Create new dashboard",
                    "new-dashboard-title": "New dashboard title",
                    "open-dashboard": "Open dashboard",
                    "set-background": "Set background",
                    "background-color": "Background color",
                    "background-image": "Background image",
                    "background-size-mode": "Background size mode",
                    "no-image": "No image selected",
                    "drop-image": "Drop an image or click to select a file to upload.",
                    "settings": "Settings",
                    "columns-count": "Columns count",
                    "columns-count-required": "Columns count is required.",
                    "min-columns-count-message": "Only 10 minimum column count is allowed.",
                    "max-columns-count-message": "Only 1000 maximum column count is allowed.",
                    "widgets-margins": "Margin between widgets",
                    "horizontal-margin": "Horizontal margin",
                    "horizontal-margin-required": "Horizontal margin value is required.",
                    "min-horizontal-margin-message": "Only 0 is allowed as minimum horizontal margin value.",
                    "max-horizontal-margin-message": "Only 50 is allowed as maximum horizontal margin value.",
                    "vertical-margin": "Vertical margin",
                    "vertical-margin-required": "Vertical margin value is required.",
                    "min-vertical-margin-message": "Only 0 is allowed as minimum vertical margin value.",
                    "max-vertical-margin-message": "Only 50 is allowed as maximum vertical margin value.",
                    "autofill-height": "Auto fill layout height",
                    "display-title": "Display dashboard title",
                    "toolbar-always-open": "Keep toolbar opened",
                    "title-color": "Title color",
                    "display-dashboards-selection": "Display dashboards selection",
                    "display-entities-selection": "Display entities selection",
                    "display-dashboard-timewindow": "Display timewindow",
                    "display-dashboard-export": "Display export",
                    "import": "Import dashboard",
                    "export": "Export dashboard",
                    "export-failed-error": "Unable to export dashboard: {{error}}",
                    "create-new-dashboard": "Create new dashboard",
                    "dashboard-file": "Dashboard file",
                    "invalid-dashboard-file-error": "Unable to import dashboard: Invalid dashboard data structure.",
                    "dashboard-import-missing-aliases-title": "Configure aliases used by imported dashboard",
                    "create-new-widget": "Create new widget",
                    "import-widget": "Import widget",
                    "widget-file": "Widget file",
                    "invalid-widget-file-error": "Unable to import widget: Invalid widget data structure.",
                    "widget-import-missing-aliases-title": "Configure aliases used by imported widget",
                    "open-toolbar": "Open dashboard toolbar",
                    "close-toolbar": "Close toolbar",
                    "configuration-error": "Configuration error",
                    "alias-resolution-error-title": "Dashboard aliases configuration error",
                    "invalid-aliases-config": "Unable to find any devices matching to some of the aliases filter.<br/>" +
                                              "Please contact your administrator in order to resolve this issue.",
                    "select-devices": "Select devices",
                    "assignedToCustomer": "Assigned to customer",
                    "public": "Public",
                    "public-link": "Public link",
                    "copy-public-link": "Copy public link",
                    "public-link-copied-message": "Dashboard public link has been copied to clipboard",
                    "manage-states": "Manage dashboard states",
                    "states": "Dashboard states",
                    "search-states": "Search dashboard states",
                    "selected-states": "{ count, select, 1 {1 dashboard state} other {# dashboard states} } selected",
                    "edit-state": "Edit dashboard state",
                    "delete-state": "Delete dashboard state",
                    "add-state": "Add dashboard state",
                    "state": "Dashboard state",
                    "state-name": "Name",
                    "state-name-required": "Dashboard state name is required.",
                    "state-id": "State Id",
                    "state-id-required": "Dashboard state id is required.",
                    "state-id-exists": "Dashboard state with the same id is already exists.",
                    "is-root-state": "Root state",
                    "delete-state-title": "Delete dashboard state",
                    "delete-state-text": "Are you sure you want delete dashboard state with name '{{stateName}}'?",
                    "show-details": "Show details",
                    "hide-details": "Hide details",
                    "select-state": "Select target state",
                    "state-controller": "State controller"
                },
                "datakey": {
                    "settings": "Settings",
                    "advanced": "Advanced",
                    "label": "Label",
                    "color": "Color",
                    "units": "Special symbol to show next to value",
                    "decimals": "Number of digits after floating point",
                    "data-generation-func": "Data generation function",
                    "use-data-post-processing-func": "Use data post-processing function",
                    "configuration": "Data key configuration",
                    "timeseries": "Timeseries",
                    "attributes": "Attributes",
                    "alarm": "Alarm fields",
                    "timeseries-required": "Entity timeseries are required.",
                    "timeseries-or-attributes-required": "Entity timeseries/attributes are required.",
                    "maximum-timeseries-or-attributes": "Maximum { count, select, 1 {1 timeseries/attribute is allowed.} other {# timeseries/attributes are allowed} }",
                    "alarm-fields-required": "Alarm fields are required.",
                    "function-types": "Function types",
                    "function-types-required": "Function types are required.",
                    "maximum-function-types": "Maximum { count, select, 1 {1 function type is allowed.} other {# function types are allowed} }"
                },
                "datasource": {
                    "type": "Datasource type",
                    "name": "Name",
                    "add-datasource-prompt": "Please add datasource"
                },
                "details": {
                    "edit-mode": "Edit mode",
                    "toggle-edit-mode": "Toggle edit mode"
                },
                "device": {
                    "device": "Device",
                    "device-required": "Device is required.",
                    "devices": "Devices",
                    "management": "Device management",
                    "view-devices": "View Devices",
                    "device-alias": "Device alias",
                    "aliases": "Device aliases",
                    "no-alias-matching": "'{{alias}}' not found.",
                    "no-aliases-found": "No aliases found.",
                    "no-key-matching": "'{{key}}' not found.",
                    "no-keys-found": "No keys found.",
                    "create-new-alias": "Create a new one!",
                    "create-new-key": "Create a new one!",
                    "duplicate-alias-error": "Duplicate alias found '{{alias}}'.<br>Device aliases must be unique whithin the dashboard.",
                    "configure-alias": "Configure '{{alias}}' alias",
                    "no-devices-matching": "No devices matching '{{entity}}' were found.",
                    "alias": "Alias",
                    "alias-required": "Device alias is required.",
                    "remove-alias": "Remove device alias",
                    "add-alias": "Add device alias",
                    "name-starts-with": "Device name starts with",
                    "device-list": "Device list",
                    "use-device-name-filter": "Use filter",
                    "device-list-empty": "No devices selected.",
                    "device-name-filter-required": "Device name filter is required.",
                    "device-name-filter-no-device-matched": "No devices starting with '{{device}}' were found.",
                    "add": "Add Device",
                    "assign-to-customer": "Assign to customer",
                    "assign-device-to-customer": "Assign Device(s) To Customer",
                    "assign-device-to-customer-text": "Please select the devices to assign to the customer",
                    "make-public": "Make device public",
                    "make-private": "Make device private",
                    "no-devices-text": "No devices found",
                    "assign-to-customer-text": "Please select the customer to assign the device(s)",
                    "device-details": "Device details",
                    "add-device-text": "Add new device",
                    "credentials": "Credentials",
                    "manage-credentials": "Manage credentials",
                    "delete": "Delete device",
                    "assign-devices": "Assign devices",
                    "assign-devices-text": "Assign { count, select, 1 {1 device} other {# devices} } to customer",
                    "delete-devices": "Delete devices",
                    "unassign-from-customer": "Unassign from customer",
                    "unassign-devices": "Unassign devices",
                    "unassign-devices-action-title": "Unassign { count, select, 1 {1 device} other {# devices} } from customer",
                    "assign-new-device": "Assign new device",
                    "make-public-device-title": "Are you sure you want to make the device '{{deviceName}}' public?",
                    "make-public-device-text": "After the confirmation the device and all its data will be made public and accessible by others.",
                    "make-private-device-title": "Are you sure you want to make the device '{{deviceName}}' private?",
                    "make-private-device-text": "After the confirmation the device and all its data will be made private and won't be accessible by others.",
                    "view-credentials": "View credentials",
                    "delete-device-title": "Are you sure you want to delete the device '{{deviceName}}'?",
                    "delete-device-text": "Be careful, after the confirmation the device and all related data will become unrecoverable.",
                    "delete-devices-title": "Are you sure you want to delete { count, select, 1 {1 device} other {# devices} }?",
                    "delete-devices-action-title": "Delete { count, select, 1 {1 device} other {# devices} }",
                    "delete-devices-text": "Be careful, after the confirmation all selected devices will be removed and all related data will become unrecoverable.",
                    "unassign-device-title": "Are you sure you want to unassign the device '{{deviceName}}'?",
                    "unassign-device-text": "After the confirmation the device will be unassigned and won't be accessible by the customer.",
                    "unassign-device": "Unassign device",
                    "unassign-devices-title": "Are you sure you want to unassign { count, select, 1 {1 device} other {# devices} }?",
                    "unassign-devices-text": "After the confirmation all selected devices will be unassigned and won't be accessible by the customer.",
                    "device-credentials": "Device Credentials",
                    "credentials-type": "Credentials type",
                    "access-token": "Access token",
                    "access-token-required": "Access token is required.",
                    "access-token-invalid": "Access token length must be from 1 to 20 characters.",
                    "rsa-key": "RSA public key",
                    "rsa-key-required": "RSA public key is required.",
                    "secret": "Secret",
                    "secret-required": "Secret is required.",
                    "device-type": "Device type",
                    "device-type-required": "Device type is required.",
                    "select-device-type": "Select device type",
                    "enter-device-type": "Enter device type",
                    "any-device": "Any device",
                    "no-device-types-matching": "No device types matching '{{entitySubtype}}' were found.",
                    "device-type-list-empty": "No device types selected.",
                    "device-types": "Device types",
                    "name": "Name",
                    "name-required": "Name is required.",
                    "description": "Description",
                    "events": "Events",
                    "details": "Details",
                    "copyId": "Copy device Id",
                    "copyAccessToken": "Copy access token",
                    "idCopiedMessage": "Device Id has been copied to clipboard",
                    "accessTokenCopiedMessage": "Device access token has been copied to clipboard",
                    "assignedToCustomer": "Assigned to customer",
                    "unable-delete-device-alias-title": "Unable to delete device alias",
                    "unable-delete-device-alias-text": "Device alias '{{deviceAlias}}' can't be deleted as it used by the following widget(s):<br/>{{widgetsList}}",
                    "is-gateway": "Is gateway",
                    "public": "Public",
                    "device-public": "Device is public",
                    "select-device": "Select device"
                },
                "dialog": {
                    "close": "Close dialog"
                },
                "error": {
                    "unable-to-connect": "Unable to connect to the server! Please check your internet connection.",
                    "unhandled-error-code": "Unhandled error code: {{errorCode}}",
                    "unknown-error": "Unknown error"
                },
                "entity": {
                    "entity": "Entity",
                    "entities": "Entities",
                    "aliases": "Entity aliases",
                    "entity-alias": "Entity alias",
                    "unable-delete-entity-alias-title": "Unable to delete entity alias",
                    "unable-delete-entity-alias-text": "Entity alias '{{entityAlias}}' can't be deleted as it used by the following widget(s):<br/>{{widgetsList}}",
                    "duplicate-alias-error": "Duplicate alias found '{{alias}}'.<br>Entity aliases must be unique whithin the dashboard.",
                    "missing-entity-filter-error": "Filter is missing for alias '{{alias}}'.",
                    "configure-alias": "Configure '{{alias}}' alias",
                    "alias": "Alias",
                    "alias-required": "Entity alias is required.",
                    "remove-alias": "Remove entity alias",
                    "add-alias": "Add entity alias",
                    "entity-list": "Entity list",
                    "entity-type": "Entity type",
                    "entity-types": "Entity types",
                    "entity-type-list": "Entity type list",
                    "any-entity": "Any entity",
                    "enter-entity-type": "Enter entity type",
                    "no-entities-matching": "No entities matching '{{entity}}' were found.",
                    "no-entity-types-matching": "No entity types matching '{{entityType}}' were found.",
                    "name-starts-with": "Name starts with",
                    "use-entity-name-filter": "Use filter",
                    "entity-list-empty": "No entities selected.",
                    "entity-type-list-empty": "No entity types selected.",
                    "entity-name-filter-required": "Entity name filter is required.",
                    "entity-name-filter-no-entity-matched": "No entities starting with '{{entity}}' were found.",
                    "all-subtypes": "All",
                    "select-entities": "Select entities",
                    "no-aliases-found": "No aliases found.",
                    "no-alias-matching": "'{{alias}}' not found.",
                    "create-new-alias": "Create a new one!",
                    "key": "Key",
                    "key-name": "Key name",
                    "no-keys-found": "No keys found.",
                    "no-key-matching": "'{{key}}' not found.",
                    "create-new-key": "Create a new one!",
                    "type": "Type",
                    "type-required": "Entity type is required.",
                    "type-device": "Device",
                    "type-devices": "Devices",
                    "list-of-devices": "{ count, select, 1 {One device} other {List of # devices} }",
                    "device-name-starts-with": "Devices whose names start with '{{prefix}}'",
                    "type-asset": "Asset",
                    "type-assets": "Assets",
                    "list-of-assets": "{ count, select, 1 {One asset} other {List of # assets} }",
                    "asset-name-starts-with": "Assets whose names start with '{{prefix}}'",
                    "type-rule": "Rule",
                    "type-rules": "Rules",
                    "list-of-rules": "{ count, select, 1 {One rule} other {List of # rules} }",
                    "rule-name-starts-with": "Rules whose names start with '{{prefix}}'",
                    "type-plugin": "Plugin",
                    "type-plugins": "Plugins",
                    "list-of-plugins": "{ count, select, 1 {One plugin} other {List of # plugins} }",
                    "plugin-name-starts-with": "Plugins whose names start with '{{prefix}}'",
                    "type-tenant": "Tenant",
                    "type-tenants": "Tenants",
                    "list-of-tenants": "{ count, select, 1 {One tenant} other {List of # tenants} }",
                    "tenant-name-starts-with": "Tenants whose names start with '{{prefix}}'",
                    "type-customer": "Customer",
                    "type-customers": "Customers",
                    "list-of-customers": "{ count, select, 1 {One customer} other {List of # customers} }",
                    "customer-name-starts-with": "Customers whose names start with '{{prefix}}'",
                    "type-user": "User",
                    "type-users": "Users",
                    "list-of-users": "{ count, select, 1 {One user} other {List of # users} }",
                    "user-name-starts-with": "Users whose names start with '{{prefix}}'",
                    "type-dashboard": "Dashboard",
                    "type-dashboards": "Dashboards",
                    "list-of-dashboards": "{ count, select, 1 {One dashboard} other {List of # dashboards} }",
                    "dashboard-name-starts-with": "Dashboards whose names start with '{{prefix}}'",
                    "type-alarm": "Alarm",
                    "type-alarms": "Alarms",
                    "list-of-alarms": "{ count, select, 1 {One alarms} other {List of # alarms} }",
                    "alarm-name-starts-with": "Alarms whose names start with '{{prefix}}'",
                    "search": "Search entities",
                    "selected-entities": "{ count, select, 1 {1 entity} other {# entities} } selected",
                    "entity-name": "Entity name",
                    "details": "Entity details",
                    "no-entities-prompt": "No entities found",
                    "no-data": "No data to display"
                },
                "event": {
                    "event-type": "Event type",
                    "type-error": "Error",
                    "type-lc-event": "Lifecycle event",
                    "type-stats": "Statistics",
                    "no-events-prompt": "No events found",
                    "error": "Error",
                    "alarm": "Alarm",
                    "event-time": "Event time",
                    "server": "Server",
                    "body": "Body",
                    "method": "Method",
                    "event": "Event",
                    "status": "Status",
                    "success": "Success",
                    "failed": "Failed",
                    "messages-processed": "Messages processed",
                    "errors-occurred": "Errors occurred"
                },
                "fullscreen": {
                    "expand": "Expand to fullscreen",
                    "exit": "Exit fullscreen",
                    "toggle": "Toggle fullscreen mode",
                    "fullscreen": "Fullscreen"
                },
                "function": {
                    "function": "Function"
                },
                "grid": {
                    "delete-item-title": "Are you sure you want to delete this item?",
                    "delete-item-text": "Be careful, after the confirmation this item and all related data will become unrecoverable.",
                    "delete-items-title": "Are you sure you want to delete { count, select, 1 {1 item} other {# items} }?",
                    "delete-items-action-title": "Delete { count, select, 1 {1 item} other {# items} }",
                    "delete-items-text": "Be careful, after the confirmation all selected items will be removed and all related data will become unrecoverable.",
                    "add-item-text": "Add new item",
                    "no-items-text": "No items found",
                    "item-details": "Item details",
                    "delete-item": "Delete Item",
                    "delete-items": "Delete Items",
                    "scroll-to-top": "Scroll to top"
                },
                "help": {
                    "goto-help-page": "Go to help page"
                },
                "home": {
                    "home": "Home",
                    "profile": "Profile",
                    "logout": "Logout",
                    "menu": "Menu",
                    "avatar": "Avatar",
                    "open-user-menu": "Open user menu"
                },
                "import": {
                    "no-file": "No file selected",
                    "drop-file": "Drop a JSON file or click to select a file to upload."
                },
                "item": {
                    "selected": "Selected"
                },
                "js-func": {
                    "no-return-error": "Function must return value!",
                    "return-type-mismatch": "Function must return value of '{{type}}' type!"
                },
                "layout": {
                    "layout": "Layout",
                    "manage": "Manage layouts",
                    "settings": "Layout settings",
                    "color": "Color",
                    "main": "Main",
                    "right": "Right",
                    "select": "Select target layout"
                },
                "legend": {
                    "position": "Legend position",
                    "show-max": "Show max value",
                    "show-min": "Show min value",
                    "show-avg": "Show average value",
                    "show-total": "Show total value",
                    "settings": "Legend settings",
                    "min": "min",
                    "max": "max",
                    "avg": "avg",
                    "total": "total"
                },
                "login": {
                    "login": "Login",
                    "request-password-reset": "Request Password Reset",
                    "reset-password": "Reset Password",
                    "create-password": "Create Password",
                    "passwords-mismatch-error": "Entered passwords must be same!",
                    "password-again": "Password again",
                    "sign-in": "Please sign in",
                    "username": "Username (email)",
                    "remember-me": "Remember me",
                    "forgot-password": "Forgot Password?",
                    "password-reset": "Password reset",
                    "new-password": "New password",
                    "new-password-again": "New password again",
                    "password-link-sent-message": "Password reset link was successfully sent!",
                    "email": "Email"
                },
                "plugin": {
                    "plugins": "Plugins",
                    "delete": "Delete plugin",
                    "activate": "Activate plugin",
                    "suspend": "Suspend plugin",
                    "active": "Active",
                    "suspended": "Suspended",
                    "name": "Name",
                    "name-required": "Name is required.",
                    "description": "Description",
                    "add": "Add Plugin",
                    "delete-plugin-title": "Are you sure you want to delete the plugin '{{pluginName}}'?",
                    "delete-plugin-text": "Be careful, after the confirmation the plugin and all related data will become unrecoverable.",
                    "delete-plugins-title": "Are you sure you want to delete { count, select, 1 {1 plugin} other {# plugins} }?",
                    "delete-plugins-action-title": "Delete { count, select, 1 {1 plugin} other {# plugins} }",
                    "delete-plugins-text": "Be careful, after the confirmation all selected plugins will be removed and all related data will become unrecoverable.",
                    "add-plugin-text": "Add new plugin",
                    "no-plugins-text": "No plugins found",
                    "plugin-details": "Plugin details",
                    "api-token": "API token",
                    "api-token-required": "API token is required.",
                    "type": "Plugin type",
                    "type-required": "Plugin type is required.",
                    "configuration": "Plugin configuration",
                    "system": "System",
                    "select-plugin": "Select plugin",
                    "plugin": "Plugin",
                    "no-plugins-matching": "No plugins matching '{{entity}}' were found.",
                    "plugin-required": "Plugin is required.",
                    "plugin-require-match": "Please select an existing plugin.",
                    "events": "Events",
                    "details": "Details",
                    "import": "Import plugin",
                    "export": "Export plugin",
                    "export-failed-error": "Unable to export plugin: {{error}}",
                    "create-new-plugin": "Create new plugin",
                    "plugin-file": "Plugin file",
                    "invalid-plugin-file-error": "Unable to import plugin: Invalid plugin data structure.",
                    "copyId": "Copy plugin Id",
                    "idCopiedMessage": "Plugin Id has been copied to clipboard"

                },
                "position": {
                    "top": "Top",
                    "bottom": "Bottom",
                    "left": "Left",
                    "right": "Right"
                },
                "profile": {
                    "profile": "Profile",
                    "change-password": "Change Password",
                    "current-password": "Current password"
                },
                "relation": {
                    "relations": "Relations",
                    "direction": "Direction",
                    "search-direction": {
                        "FROM": "From",
                        "TO": "To"
                    },
                    "direction-type": {
                        "FROM": "from",
                        "TO": "to"
                    },
                    "from-relations": "Outbound relations",
                    "to-relations": "Inbound relations",
                    "selected-relations": "{ count, select, 1 {1 relation} other {# relations} } selected",
                    "type": "Type",
                    "to-entity-type": "To entity type",
                    "to-entity-name": "To entity name",
                    "from-entity-type": "From entity type",
                    "from-entity-name": "From entity name",
                    "to-entity": "To entity",
                    "from-entity": "From entity",
                    "delete": "Delete relation",
                    "relation-type": "Relation type",
                    "relation-type-required": "Relation type is required.",
                    "any-relation-type": "Any type",
                    "add": "Add relation",
                    "delete-to-relation-title": "Are you sure you want to delete relation to the entity '{{entityName}}'?",
                    "delete-to-relation-text": "Be careful, after the confirmation the entity '{{entityName}}' will be unrelated from the current entity.",
                    "delete-to-relations-title": "Are you sure you want to delete { count, select, 1 {1 relation} other {# relations} }?",
                    "delete-to-relations-text": "Be careful, after the confirmation all selected relations will be removed and corresponding entities will be unrelated from the current entity.",
                    "delete-from-relation-title": "Are you sure you want to delete relation from the entity '{{entityName}}'?",
                    "delete-from-relation-text": "Be careful, after the confirmation current entity will be unrelated from the entity '{{entityName}}'.",
                    "delete-from-relations-title": "Are you sure you want to delete { count, select, 1 {1 relation} other {# relations} }?",
                    "delete-from-relations-text": "Be careful, after the confirmation all selected relations will be removed and current entity will be unrelated from the corresponding entities.",
                    "remove-relation-filter": "Remove relation filter",
                    "add-relation-filter": "Add relation filter",
                    "any-relation": "Any relation",
                    "relation-filters": "Relation filters"
                },
                "rule": {
                    "rule": "Rule",
                    "rules": "Rules",
                    "delete": "Delete rule",
                    "activate": "Activate rule",
                    "suspend": "Suspend rule",
                    "active": "Active",
                    "suspended": "Suspended",
                    "name": "Name",
                    "name-required": "Name is required.",
                    "description": "Description",
                    "add": "Add Rule",
                    "delete-rule-title": "Are you sure you want to delete the rule '{{ruleName}}'?",
                    "delete-rule-text": "Be careful, after the confirmation the rule and all related data will become unrecoverable.",
                    "delete-rules-title": "Are you sure you want to delete { count, select, 1 {1 rule} other {# rules} }?",
                    "delete-rules-action-title": "Delete { count, select, 1 {1 rule} other {# rules} }",
                    "delete-rules-text": "Be careful, after the confirmation all selected rules will be removed and all related data will become unrecoverable.",
                    "add-rule-text": "Add new rule",
                    "no-rules-text": "No rules found",
                    "rule-details": "Rule details",
                    "filters": "Filters",
                    "filter": "Filter",
                    "add-filter-prompt": "Please add filter",
                    "remove-filter": "Remove filter",
                    "add-filter": "Add filter",
                    "filter-name": "Filter name",
                    "filter-type": "Filter type",
                    "edit-filter": "Edit filter",
                    "view-filter": "View filter",
                    "component-name": "Name",
                    "component-name-required": "Name is required.",
                    "component-type": "Type",
                    "component-type-required": "Type is required.",
                    "processor": "Processor",
                    "no-processor-configured": "No processor configured",
                    "create-processor": "Create processor",
                    "processor-name": "Processor name",
                    "processor-type": "Processor type",
                    "plugin-action": "Plugin action",
                    "action-name": "Action name",
                    "action-type": "Action type",
                    "create-action-prompt": "Please create action",
                    "create-action": "Create action",
                    "details": "Details",
                    "events": "Events",
                    "system": "System",
                    "import": "Import rule",
                    "export": "Export rule",
                    "export-failed-error": "Unable to export rule: {{error}}",
                    "create-new-rule": "Create new rule",
                    "rule-file": "Rule file",
                    "invalid-rule-file-error": "Unable to import rule: Invalid rule data structure.",
                    "copyId": "Copy rule Id",
                    "idCopiedMessage": "Rule Id has been copied to clipboard",
                    "select-rule": "Select rule",
                    "no-rules-matching": "No rules matching '{{entity}}' were found.",
                    "rule-required": "Rule is required"
                },
                "rule-plugin": {
                    "management": "Rules and plugins management"
                },
                "tenant": {
                    "tenant": "Tenant",
                    "tenants": "Tenants",
                    "management": "Tenant management",
                    "add": "Add Tenant",
                    "admins": "Admins",
                    "manage-tenant-admins": "Manage tenant admins",
                    "delete": "Delete tenant",
                    "add-tenant-text": "Add new tenant",
                    "no-tenants-text": "No tenants found",
                    "tenant-details": "Tenant details",
                    "delete-tenant-title": "Are you sure you want to delete the tenant '{{tenantTitle}}'?",
                    "delete-tenant-text": "Be careful, after the confirmation the tenant and all related data will become unrecoverable.",
                    "delete-tenants-title": "Are you sure you want to delete { count, select, 1 {1 tenant} other {# tenants} }?",
                    "delete-tenants-action-title": "Delete { count, select, 1 {1 tenant} other {# tenants} }",
                    "delete-tenants-text": "Be careful, after the confirmation all selected tenants will be removed and all related data will become unrecoverable.",
                    "title": "Title",
                    "title-required": "Title is required.",
                    "description": "Description",
                    "details": "Details",
                    "events": "Events",
                    "copyId": "Copy tenant Id",
                    "idCopiedMessage": "Tenant Id has been copied to clipboard",
                    "select-tenant": "Select tenant",
                    "no-tenants-matching": "No tenants matching '{{entity}}' were found.",
                    "tenant-required": "Tenant is required"
                },
                "timeinterval": {
                    "seconds-interval": "{ seconds, select, 1 {1 second} other {# seconds} }",
                    "minutes-interval": "{ minutes, select, 1 {1 minute} other {# minutes} }",
                    "hours-interval": "{ hours, select, 1 {1 hour} other {# hours} }",
                    "days-interval": "{ days, select, 1 {1 day} other {# days} }",
                    "days": "Days",
                    "hours": "Hours",
                    "minutes": "Minutes",
                    "seconds": "Seconds",
                    "advanced": "Advanced"
                },
                "timewindow": {
                    "days": "{ days, select, 1 { day } other {# days } }",
                    "hours": "{ hours, select, 0 { hour } 1 {1 hour } other {# hours } }",
                    "minutes": "{ minutes, select, 0 { minute } 1 {1 minute } other {# minutes } }",
                    "seconds": "{ seconds, select, 0 { second } 1 {1 second } other {# seconds } }",
                    "realtime": "Realtime",
                    "history": "History",
                    "last-prefix": "last",
                    "period": "from {{ startTime }} to {{ endTime }}",
                    "edit": "Edit timewindow",
                    "date-range": "Date range",
                    "last": "Last",
                    "time-period": "Time period"
                },
                "user": {
                    "user": "User",
                    "users": "Users",
                    "customer-users": "Customer Users",
                    "tenant-admins": "Tenant Admins",
                    "sys-admin": "System administrator",
                    "tenant-admin": "Tenant administrator",
                    "customer": "Customer",
                    "anonymous": "Anonymous",
                    "add": "Add User",
                    "delete": "Delete user",
                    "add-user-text": "Add new user",
                    "no-users-text": "No users found",
                    "user-details": "User details",
                    "delete-user-title": "Are you sure you want to delete the user '{{userEmail}}'?",
                    "delete-user-text": "Be careful, after the confirmation the user and all related data will become unrecoverable.",
                    "delete-users-title": "Are you sure you want to delete { count, select, 1 {1 user} other {# users} }?",
                    "delete-users-action-title": "Delete { count, select, 1 {1 user} other {# users} }",
                    "delete-users-text": "Be careful, after the confirmation all selected users will be removed and all related data will become unrecoverable.",
                    "activation-email-sent-message": "Activation email was successfully sent!",
                    "resend-activation": "Resend activation",
                    "email": "Email",
                    "email-required": "Email is required.",
                    "first-name": "First Name",
                    "last-name": "Last Name",
                    "description": "Description",
                    "default-dashboard": "Default dashboard",
                    "always-fullscreen": "Always fullscreen",
                    "select-user": "Select user",
                    "no-users-matching": "No users matching '{{entity}}' were found.",
                    "user-required": "User is required"
                },
                "value": {
                    "type": "Value type",
                    "string": "String",
                    "string-value": "String value",
                    "integer": "Integer",
                    "integer-value": "Integer value",
                    "invalid-integer-value": "Invalid integer value",
                    "double": "Double",
                    "double-value": "Double value",
                    "boolean": "Boolean",
                    "boolean-value": "Boolean value",
                    "false": "False",
                    "true": "True"
                },
                "widget": {
                    "widget-library": "Widgets Library",
                    "widget-bundle": "Widgets Bundle",
                    "select-widgets-bundle": "Select widgets bundle",
                    "management": "Widget management",
                    "editor": "Widget Editor",
                    "widget-type-not-found": "Problem loading widget configuration.<br>Probably associated\n    widget type was removed.",
                    "widget-type-load-error": "Widget wasn't loaded due to the following errors:",
                    "remove": "Remove widget",
                    "edit": "Edit widget",
                    "remove-widget-title": "Are you sure you want to remove the widget '{{widgetTitle}}'?",
                    "remove-widget-text": "After the confirmation the widget and all related data will become unrecoverable.",
                    "timeseries": "Time series",
                    "latest-values": "Latest values",
                    "rpc": "Control widget",
                    "alarm": "Alarm widget",
                    "static": "Static widget",
                    "select-widget-type": "Select widget type",
                    "missing-widget-title-error": "Widget title must be specified!",
                    "widget-saved": "Widget saved",
                    "unable-to-save-widget-error": "Unable to save widget! Widget has errors!",
                    "save": "Save widget",
                    "saveAs": "Save widget as",
                    "save-widget-type-as": "Save widget type as",
                    "save-widget-type-as-text": "Please enter new widget title and/or select target widgets bundle",
                    "toggle-fullscreen": "Toggle fullscreen",
                    "run": "Run widget",
                    "title": "Widget title",
                    "title-required": "Widget title is required.",
                    "type": "Widget type",
                    "resources": "Resources",
                    "resource-url": "JavaScript/CSS URL",
                    "remove-resource": "Remove resource",
                    "add-resource": "Add resource",
                    "html": "HTML",
                    "tidy": "Tidy",
                    "css": "CSS",
                    "settings-schema": "Settings schema",
                    "datakey-settings-schema": "Data key settings schema",
                    "javascript": "Javascript",
                    "remove-widget-type-title": "Are you sure you want to remove the widget type '{{widgetName}}'?",
                    "remove-widget-type-text": "After the confirmation the widget type and all related data will become unrecoverable.",
                    "remove-widget-type": "Remove widget type",
                    "add-widget-type": "Add new widget type",
                    "widget-type-load-failed-error": "Failed to load widget type!",
                    "widget-template-load-failed-error": "Failed to load widget template!",
                    "add": "Add Widget",
                    "undo": "Undo widget changes",
                    "export": "Export widget"
                },
                "widget-action": {
                    "header-button": "Widget header button",
                    "open-dashboard-state": "Navigate to new dashboard state",
                    "update-dashboard-state": "Update current dashboard state",
                    "open-dashboard": "Navigate to other dashboard",
                    "custom": "Custom action",
                    "target-dashboard-state": "Target dashboard state",
                    "target-dashboard-state-required": "Target dashboard state is required",
                    "set-entity-from-widget": "Set entity from widget",
                    "target-dashboard": "Target dashboard",
                    "open-right-layout": "Open right dashboard layout (mobile view)"
                },
                "widgets-bundle": {
                    "current": "Current bundle",
                    "widgets-bundles": "Widgets Bundles",
                    "add": "Add Widgets Bundle",
                    "delete": "Delete widgets bundle",
                    "title": "Title",
                    "title-required": "Title is required.",
                    "add-widgets-bundle-text": "Add new widgets bundle",
                    "no-widgets-bundles-text": "No widgets bundles found",
                    "empty": "Widgets bundle is empty",
                    "details": "Details",
                    "widgets-bundle-details": "Widgets bundle details",
                    "delete-widgets-bundle-title": "Are you sure you want to delete the widgets bundle '{{widgetsBundleTitle}}'?",
                    "delete-widgets-bundle-text": "Be careful, after the confirmation the widgets bundle and all related data will become unrecoverable.",
                    "delete-widgets-bundles-title": "Are you sure you want to delete { count, select, 1 {1 widgets bundle} other {# widgets bundles} }?",
                    "delete-widgets-bundles-action-title": "Delete { count, select, 1 {1 widgets bundle} other {# widgets bundles} }",
                    "delete-widgets-bundles-text": "Be careful, after the confirmation all selected widgets bundles will be removed and all related data will become unrecoverable.",
                    "no-widgets-bundles-matching": "No widgets bundles matching '{{widgetsBundle}}' were found.",
                    "widgets-bundle-required": "Widgets bundle is required.",
                    "system": "System",
                    "import": "Import widgets bundle",
                    "export": "Export widgets bundle",
                    "export-failed-error": "Unable to export widgets bundle: {{error}}",
                    "create-new-widgets-bundle": "Create new widgets bundle",
                    "widgets-bundle-file": "Widgets bundle file",
                    "invalid-widgets-bundle-file-error": "Unable to import widgets bundle: Invalid widgets bundle data structure."
                },
                "widget-config": {
                    "data": "Data",
                    "settings": "Settings",
                    "advanced": "Advanced",
                    "title": "Title",
                    "general-settings": "General settings",
                    "display-title": "Display title",
                    "drop-shadow": "Drop shadow",
                    "enable-fullscreen": "Enable fullscreen",
                    "background-color": "Background color",
                    "text-color": "Text color",
                    "padding": "Padding",
                    "title-style": "Title style",
                    "mobile-mode-settings": "Mobile mode settings",
                    "order": "Order",
                    "height": "Height",
                    "units": "Special symbol to show next to value",
                    "decimals": "Number of digits after floating point",
                    "timewindow": "Timewindow",
                    "use-dashboard-timewindow": "Use dashboard timewindow",
                    "display-legend": "Display legend",
                    "datasources": "Datasources",
                    "maximum-datasources": "Maximum { count, select, 1 {1 datasource is allowed.} other {# datasources are allowed} }",
                    "datasource-type": "Type",
                    "datasource-parameters": "Parameters",
                    "remove-datasource": "Remove datasource",
                    "add-datasource": "Add datasource",
                    "target-device": "Target device",
                    "alarm-source": "Alarm source",
                    "actions": "Actions",
                    "action": "Action",
                    "add-action": "Add action",
                    "search-actions": "Search actions",
                    "action-source": "Action source",
                    "action-source-required": "Action source is required.",
                    "action-name": "Name",
                    "action-name-required": "Action name is required.",
                    "action-name-not-unique": "Another action with the same name already exists.<br/>Action name should be unique within the same action source.",
                    "action-icon": "Icon",
                    "action-type": "Type",
                    "action-type-required": "Action type is required.",
                    "edit-action": "Edit action",
                    "delete-action": "Delete action",
                    "delete-action-title": "Delete widget action",
                    "delete-action-text": "Are you sure you want delete widget action with name '{{actionName}}'?"
                },
                "widget-type": {
                    "import": "Import widget type",
                    "export": "Export widget type",
                    "export-failed-error": "Unable to export widget type: {{error}}",
                    "create-new-widget-type": "Create new widget type",
                    "widget-type-file": "Widget type file",
                    "invalid-widget-type-file-error": "Unable to import widget type: Invalid widget type data structure."
                },
                "icon": {
                    "icon": "Icon",
                    "select-icon": "Select icon",
                    "material-icons": "Material icons",
                    "show-all": "Show all icons"
                },
                "language": {
                    "language": "Language",
                    "en_US": "English",
                    "ko_KR": "Korean",
                    "zh_CN": "Chinese",
                    "ru_RU": "Russian",
                    "es_ES": "Spanish"
                },
                "custom": {
                    "widget-action": {
                        "action-cell-button": "Action cell button",
                        "row-click": "On row click"
                    }
                }
            }
        }
    ).name;
